/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNotificationSubscriptionRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DeleteNotificationSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteNotificationSubscriptionRequest.getter(DeleteNotificationSubscriptionRequest::subscriptionId)).setter(DeleteNotificationSubscriptionRequest.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscriptionId").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteNotificationSubscriptionRequest.getter(DeleteNotificationSubscriptionRequest::organizationId)).setter(DeleteNotificationSubscriptionRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OrganizationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ID_FIELD, ORGANIZATION_ID_FIELD));
    private final String subscriptionId;
    private final String organizationId;

    private DeleteNotificationSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionId = builder.subscriptionId;
        this.organizationId = builder.organizationId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String organizationId() {
        return this.organizationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNotificationSubscriptionRequest)) {
            return false;
        }
        DeleteNotificationSubscriptionRequest other = (DeleteNotificationSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.organizationId(), other.organizationId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteNotificationSubscriptionRequest").add("SubscriptionId", (Object)this.subscriptionId()).add("OrganizationId", (Object)this.organizationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNotificationSubscriptionRequest, T> g) {
        return obj -> g.apply((DeleteNotificationSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String organizationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNotificationSubscriptionRequest model) {
            super(model);
            this.subscriptionId(model.subscriptionId);
            this.organizationId(model.organizationId);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNotificationSubscriptionRequest build() {
            return new DeleteNotificationSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNotificationSubscriptionRequest> {
        public Builder subscriptionId(String var1);

        public Builder organizationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

