/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.ActivityType;
import software.amazon.awssdk.services.workdocs.model.CommentMetadata;
import software.amazon.awssdk.services.workdocs.model.Participants;
import software.amazon.awssdk.services.workdocs.model.ResourceMetadata;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Activity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Activity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Activity.getter(Activity::typeAsString)).setter(Activity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Activity.getter(Activity::timeStamp)).setter(Activity.setter(Builder::timeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeStamp").build()}).build();
    private static final SdkField<Boolean> IS_INDIRECT_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Activity.getter(Activity::isIndirectActivity)).setter(Activity.setter(Builder::isIndirectActivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIndirectActivity").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Activity.getter(Activity::organizationId)).setter(Activity.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<UserMetadata> INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Activity.getter(Activity::initiator)).setter(Activity.setter(Builder::initiator)).constructor(UserMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiator").build()}).build();
    private static final SdkField<Participants> PARTICIPANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Activity.getter(Activity::participants)).setter(Activity.setter(Builder::participants)).constructor(Participants::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Participants").build()}).build();
    private static final SdkField<ResourceMetadata> RESOURCE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Activity.getter(Activity::resourceMetadata)).setter(Activity.setter(Builder::resourceMetadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceMetadata").build()}).build();
    private static final SdkField<ResourceMetadata> ORIGINAL_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Activity.getter(Activity::originalParent)).setter(Activity.setter(Builder::originalParent)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalParent").build()}).build();
    private static final SdkField<CommentMetadata> COMMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Activity.getter(Activity::commentMetadata)).setter(Activity.setter(Builder::commentMetadata)).constructor(CommentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TIME_STAMP_FIELD, IS_INDIRECT_ACTIVITY_FIELD, ORGANIZATION_ID_FIELD, INITIATOR_FIELD, PARTICIPANTS_FIELD, RESOURCE_METADATA_FIELD, ORIGINAL_PARENT_FIELD, COMMENT_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Instant timeStamp;
    private final Boolean isIndirectActivity;
    private final String organizationId;
    private final UserMetadata initiator;
    private final Participants participants;
    private final ResourceMetadata resourceMetadata;
    private final ResourceMetadata originalParent;
    private final CommentMetadata commentMetadata;

    private Activity(BuilderImpl builder) {
        this.type = builder.type;
        this.timeStamp = builder.timeStamp;
        this.isIndirectActivity = builder.isIndirectActivity;
        this.organizationId = builder.organizationId;
        this.initiator = builder.initiator;
        this.participants = builder.participants;
        this.resourceMetadata = builder.resourceMetadata;
        this.originalParent = builder.originalParent;
        this.commentMetadata = builder.commentMetadata;
    }

    public ActivityType type() {
        return ActivityType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant timeStamp() {
        return this.timeStamp;
    }

    public Boolean isIndirectActivity() {
        return this.isIndirectActivity;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public UserMetadata initiator() {
        return this.initiator;
    }

    public Participants participants() {
        return this.participants;
    }

    public ResourceMetadata resourceMetadata() {
        return this.resourceMetadata;
    }

    public ResourceMetadata originalParent() {
        return this.originalParent;
    }

    public CommentMetadata commentMetadata() {
        return this.commentMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIndirectActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiator());
        hashCode = 31 * hashCode + Objects.hashCode(this.participants());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.commentMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.timeStamp(), other.timeStamp()) && Objects.equals(this.isIndirectActivity(), other.isIndirectActivity()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.initiator(), other.initiator()) && Objects.equals(this.participants(), other.participants()) && Objects.equals(this.resourceMetadata(), other.resourceMetadata()) && Objects.equals(this.originalParent(), other.originalParent()) && Objects.equals(this.commentMetadata(), other.commentMetadata());
    }

    public String toString() {
        return ToString.builder((String)"Activity").add("Type", (Object)this.typeAsString()).add("TimeStamp", (Object)this.timeStamp()).add("IsIndirectActivity", (Object)this.isIndirectActivity()).add("OrganizationId", (Object)this.organizationId()).add("Initiator", (Object)this.initiator()).add("Participants", (Object)this.participants()).add("ResourceMetadata", (Object)this.resourceMetadata()).add("OriginalParent", (Object)this.originalParent()).add("CommentMetadata", (Object)this.commentMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TimeStamp": {
                return Optional.ofNullable(clazz.cast(this.timeStamp()));
            }
            case "IsIndirectActivity": {
                return Optional.ofNullable(clazz.cast(this.isIndirectActivity()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Initiator": {
                return Optional.ofNullable(clazz.cast(this.initiator()));
            }
            case "Participants": {
                return Optional.ofNullable(clazz.cast(this.participants()));
            }
            case "ResourceMetadata": {
                return Optional.ofNullable(clazz.cast(this.resourceMetadata()));
            }
            case "OriginalParent": {
                return Optional.ofNullable(clazz.cast(this.originalParent()));
            }
            case "CommentMetadata": {
                return Optional.ofNullable(clazz.cast(this.commentMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Activity, T> g) {
        return obj -> g.apply((Activity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Instant timeStamp;
        private Boolean isIndirectActivity;
        private String organizationId;
        private UserMetadata initiator;
        private Participants participants;
        private ResourceMetadata resourceMetadata;
        private ResourceMetadata originalParent;
        private CommentMetadata commentMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            this.type(model.type);
            this.timeStamp(model.timeStamp);
            this.isIndirectActivity(model.isIndirectActivity);
            this.organizationId(model.organizationId);
            this.initiator(model.initiator);
            this.participants(model.participants);
            this.resourceMetadata(model.resourceMetadata);
            this.originalParent(model.originalParent);
            this.commentMetadata(model.commentMetadata);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActivityType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        public final Boolean getIsIndirectActivity() {
            return this.isIndirectActivity;
        }

        @Override
        public final Builder isIndirectActivity(Boolean isIndirectActivity) {
            this.isIndirectActivity = isIndirectActivity;
            return this;
        }

        public final void setIsIndirectActivity(Boolean isIndirectActivity) {
            this.isIndirectActivity = isIndirectActivity;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final UserMetadata.Builder getInitiator() {
            return this.initiator != null ? this.initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(UserMetadata initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(UserMetadata.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        public final Participants.Builder getParticipants() {
            return this.participants != null ? this.participants.toBuilder() : null;
        }

        @Override
        public final Builder participants(Participants participants) {
            this.participants = participants;
            return this;
        }

        public final void setParticipants(Participants.BuilderImpl participants) {
            this.participants = participants != null ? participants.build() : null;
        }

        public final ResourceMetadata.Builder getResourceMetadata() {
            return this.resourceMetadata != null ? this.resourceMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resourceMetadata(ResourceMetadata resourceMetadata) {
            this.resourceMetadata = resourceMetadata;
            return this;
        }

        public final void setResourceMetadata(ResourceMetadata.BuilderImpl resourceMetadata) {
            this.resourceMetadata = resourceMetadata != null ? resourceMetadata.build() : null;
        }

        public final ResourceMetadata.Builder getOriginalParent() {
            return this.originalParent != null ? this.originalParent.toBuilder() : null;
        }

        @Override
        public final Builder originalParent(ResourceMetadata originalParent) {
            this.originalParent = originalParent;
            return this;
        }

        public final void setOriginalParent(ResourceMetadata.BuilderImpl originalParent) {
            this.originalParent = originalParent != null ? originalParent.build() : null;
        }

        public final CommentMetadata.Builder getCommentMetadata() {
            return this.commentMetadata != null ? this.commentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder commentMetadata(CommentMetadata commentMetadata) {
            this.commentMetadata = commentMetadata;
            return this;
        }

        public final void setCommentMetadata(CommentMetadata.BuilderImpl commentMetadata) {
            this.commentMetadata = commentMetadata != null ? commentMetadata.build() : null;
        }

        public Activity build() {
            return new Activity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Activity> {
        public Builder type(String var1);

        public Builder type(ActivityType var1);

        public Builder timeStamp(Instant var1);

        public Builder isIndirectActivity(Boolean var1);

        public Builder organizationId(String var1);

        public Builder initiator(UserMetadata var1);

        default public Builder initiator(Consumer<UserMetadata.Builder> initiator) {
            return this.initiator((UserMetadata)((UserMetadata.Builder)UserMetadata.builder().applyMutation(initiator)).build());
        }

        public Builder participants(Participants var1);

        default public Builder participants(Consumer<Participants.Builder> participants) {
            return this.participants((Participants)((Participants.Builder)Participants.builder().applyMutation(participants)).build());
        }

        public Builder resourceMetadata(ResourceMetadata var1);

        default public Builder resourceMetadata(Consumer<ResourceMetadata.Builder> resourceMetadata) {
            return this.resourceMetadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(resourceMetadata)).build());
        }

        public Builder originalParent(ResourceMetadata var1);

        default public Builder originalParent(Consumer<ResourceMetadata.Builder> originalParent) {
            return this.originalParent((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(originalParent)).build());
        }

        public Builder commentMetadata(CommentMetadata var1);

        default public Builder commentMetadata(Consumer<CommentMetadata.Builder> commentMetadata) {
            return this.commentMetadata((CommentMetadata)((CommentMetadata.Builder)CommentMetadata.builder().applyMutation(commentMetadata)).build());
        }
    }
}

