/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.RolePermissionType;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionInfo> {
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PermissionInfo.getter(PermissionInfo::roleAsString)).setter(PermissionInfo.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PermissionInfo.getter(PermissionInfo::typeAsString)).setter(PermissionInfo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String role;
    private final String type;

    private PermissionInfo(BuilderImpl builder) {
        this.role = builder.role;
        this.type = builder.type;
    }

    public RoleType role() {
        return RoleType.fromValue(this.role);
    }

    public String roleAsString() {
        return this.role;
    }

    public RolePermissionType type() {
        return RolePermissionType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo other = (PermissionInfo)obj;
        return Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"PermissionInfo").add("Role", (Object)this.roleAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionInfo, T> g) {
        return obj -> g.apply((PermissionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String role;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionInfo model) {
            this.role(model.role);
            this.type(model.type);
        }

        public final String getRoleAsString() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RolePermissionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public PermissionInfo build() {
            return new PermissionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionInfo> {
        public Builder role(String var1);

        public Builder role(RoleType var1);

        public Builder type(String var1);

        public Builder type(RolePermissionType var1);
    }
}

