/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.ShareResult;
import software.amazon.awssdk.services.workdocs.model.ShareResultsListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddResourcePermissionsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, AddResourcePermissionsResponse> {
    private static final SdkField<List<ShareResult>> SHARE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddResourcePermissionsResponse.getter(AddResourcePermissionsResponse::shareResults)).setter(AddResourcePermissionsResponse.setter(Builder::shareResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShareResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_RESULTS_FIELD));
    private final List<ShareResult> shareResults;

    private AddResourcePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.shareResults = builder.shareResults;
    }

    public List<ShareResult> shareResults() {
        return this.shareResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddResourcePermissionsResponse)) {
            return false;
        }
        AddResourcePermissionsResponse other = (AddResourcePermissionsResponse)((Object)obj);
        return Objects.equals(this.shareResults(), other.shareResults());
    }

    public String toString() {
        return ToString.builder((String)"AddResourcePermissionsResponse").add("ShareResults", this.shareResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareResults": {
                return Optional.ofNullable(clazz.cast(this.shareResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddResourcePermissionsResponse, T> g) {
        return obj -> g.apply((AddResourcePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<ShareResult> shareResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddResourcePermissionsResponse model) {
            super(model);
            this.shareResults(model.shareResults);
        }

        public final Collection<ShareResult.Builder> getShareResults() {
            return this.shareResults != null ? (Collection)this.shareResults.stream().map(ShareResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder shareResults(Collection<ShareResult> shareResults) {
            this.shareResults = ShareResultsListCopier.copy(shareResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareResults(ShareResult ... shareResults) {
            this.shareResults(Arrays.asList(shareResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareResults(Consumer<ShareResult.Builder> ... shareResults) {
            this.shareResults(Stream.of(shareResults).map(c -> (ShareResult)((ShareResult.Builder)ShareResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShareResults(Collection<ShareResult.BuilderImpl> shareResults) {
            this.shareResults = ShareResultsListCopier.copyFromBuilder(shareResults);
        }

        @Override
        public AddResourcePermissionsResponse build() {
            return new AddResourcePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddResourcePermissionsResponse> {
        public Builder shareResults(Collection<ShareResult> var1);

        public Builder shareResults(ShareResult ... var1);

        public Builder shareResults(Consumer<ShareResult.Builder> ... var1);
    }
}

