/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.workdocs.model.DocumentSourceType;
import software.amazon.awssdk.services.workdocs.model.DocumentSourceUrlMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentStatusType;
import software.amazon.awssdk.services.workdocs.model.DocumentThumbnailType;
import software.amazon.awssdk.services.workdocs.model.DocumentThumbnailUrlMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentVersionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentVersionMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::id)).setter(DocumentVersionMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::name)).setter(DocumentVersionMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::contentType)).setter(DocumentVersionMetadata.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::size)).setter(DocumentVersionMetadata.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::signature)).setter(DocumentVersionMetadata.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::statusAsString)).setter(DocumentVersionMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::createdTimestamp)).setter(DocumentVersionMetadata.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::modifiedTimestamp)).setter(DocumentVersionMetadata.setter(Builder::modifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()}).build();
    private static final SdkField<Instant> CONTENT_CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::contentCreatedTimestamp)).setter(DocumentVersionMetadata.setter(Builder::contentCreatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentCreatedTimestamp").build()}).build();
    private static final SdkField<Instant> CONTENT_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::contentModifiedTimestamp)).setter(DocumentVersionMetadata.setter(Builder::contentModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentModifiedTimestamp").build()}).build();
    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::creatorId)).setter(DocumentVersionMetadata.setter(Builder::creatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()}).build();
    private static final SdkField<Map<String, String>> THUMBNAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::thumbnailAsStrings)).setter(DocumentVersionMetadata.setter(Builder::thumbnailWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbnail").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DocumentVersionMetadata.getter(DocumentVersionMetadata::sourceAsStrings)).setter(DocumentVersionMetadata.setter(Builder::sourceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CONTENT_TYPE_FIELD, SIZE_FIELD, SIGNATURE_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, CONTENT_CREATED_TIMESTAMP_FIELD, CONTENT_MODIFIED_TIMESTAMP_FIELD, CREATOR_ID_FIELD, THUMBNAIL_FIELD, SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String contentType;
    private final Long size;
    private final String signature;
    private final String status;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final Instant contentCreatedTimestamp;
    private final Instant contentModifiedTimestamp;
    private final String creatorId;
    private final Map<String, String> thumbnail;
    private final Map<String, String> source;

    private DocumentVersionMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.contentType = builder.contentType;
        this.size = builder.size;
        this.signature = builder.signature;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.contentCreatedTimestamp = builder.contentCreatedTimestamp;
        this.contentModifiedTimestamp = builder.contentModifiedTimestamp;
        this.creatorId = builder.creatorId;
        this.thumbnail = builder.thumbnail;
        this.source = builder.source;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String contentType() {
        return this.contentType;
    }

    public Long size() {
        return this.size;
    }

    public String signature() {
        return this.signature;
    }

    public DocumentStatusType status() {
        return DocumentStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public Instant contentCreatedTimestamp() {
        return this.contentCreatedTimestamp;
    }

    public Instant contentModifiedTimestamp() {
        return this.contentModifiedTimestamp;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public Map<DocumentThumbnailType, String> thumbnail() {
        return TypeConverter.convert(this.thumbnail, DocumentThumbnailType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)DocumentThumbnailType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> thumbnailAsStrings() {
        return this.thumbnail;
    }

    public Map<DocumentSourceType, String> source() {
        return TypeConverter.convert(this.source, DocumentSourceType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)DocumentSourceType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> sourceAsStrings() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentCreatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionMetadata)) {
            return false;
        }
        DocumentVersionMetadata other = (DocumentVersionMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.signature(), other.signature()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.contentCreatedTimestamp(), other.contentCreatedTimestamp()) && Objects.equals(this.contentModifiedTimestamp(), other.contentModifiedTimestamp()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.thumbnailAsStrings(), other.thumbnailAsStrings()) && Objects.equals(this.sourceAsStrings(), other.sourceAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"DocumentVersionMetadata").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ContentType", (Object)this.contentType()).add("Size", (Object)this.size()).add("Signature", (Object)this.signature()).add("Status", (Object)this.statusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ModifiedTimestamp", (Object)this.modifiedTimestamp()).add("ContentCreatedTimestamp", (Object)this.contentCreatedTimestamp()).add("ContentModifiedTimestamp", (Object)this.contentModifiedTimestamp()).add("CreatorId", (Object)this.creatorId()).add("Thumbnail", this.thumbnailAsStrings()).add("Source", this.sourceAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "Signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimestamp()));
            }
            case "ContentCreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.contentCreatedTimestamp()));
            }
            case "ContentModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.contentModifiedTimestamp()));
            }
            case "CreatorId": {
                return Optional.ofNullable(clazz.cast(this.creatorId()));
            }
            case "Thumbnail": {
                return Optional.ofNullable(clazz.cast(this.thumbnailAsStrings()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentVersionMetadata, T> g) {
        return obj -> g.apply((DocumentVersionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String contentType;
        private Long size;
        private String signature;
        private String status;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private Instant contentCreatedTimestamp;
        private Instant contentModifiedTimestamp;
        private String creatorId;
        private Map<String, String> thumbnail = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> source = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionMetadata model) {
            this.id(model.id);
            this.name(model.name);
            this.contentType(model.contentType);
            this.size(model.size);
            this.signature(model.signature);
            this.status(model.status);
            this.createdTimestamp(model.createdTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.contentCreatedTimestamp(model.contentCreatedTimestamp);
            this.contentModifiedTimestamp(model.contentModifiedTimestamp);
            this.creatorId(model.creatorId);
            this.thumbnailWithStrings(model.thumbnail);
            this.sourceWithStrings(model.source);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final Instant getContentCreatedTimestamp() {
            return this.contentCreatedTimestamp;
        }

        @Override
        public final Builder contentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
            return this;
        }

        public final void setContentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
        }

        public final Instant getContentModifiedTimestamp() {
            return this.contentModifiedTimestamp;
        }

        @Override
        public final Builder contentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
            return this;
        }

        public final void setContentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final Map<String, String> getThumbnailAsStrings() {
            return this.thumbnail;
        }

        @Override
        public final Builder thumbnailWithStrings(Map<String, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copy(thumbnail);
            return this;
        }

        @Override
        public final Builder thumbnail(Map<DocumentThumbnailType, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copyEnumToString(thumbnail);
            return this;
        }

        public final void setThumbnailWithStrings(Map<String, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copy(thumbnail);
        }

        public final Map<String, String> getSourceAsStrings() {
            return this.source;
        }

        @Override
        public final Builder sourceWithStrings(Map<String, String> source) {
            this.source = DocumentSourceUrlMapCopier.copy(source);
            return this;
        }

        @Override
        public final Builder source(Map<DocumentSourceType, String> source) {
            this.source = DocumentSourceUrlMapCopier.copyEnumToString(source);
            return this;
        }

        public final void setSourceWithStrings(Map<String, String> source) {
            this.source = DocumentSourceUrlMapCopier.copy(source);
        }

        public DocumentVersionMetadata build() {
            return new DocumentVersionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentVersionMetadata> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder contentType(String var1);

        public Builder size(Long var1);

        public Builder signature(String var1);

        public Builder status(String var1);

        public Builder status(DocumentStatusType var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder contentCreatedTimestamp(Instant var1);

        public Builder contentModifiedTimestamp(Instant var1);

        public Builder creatorId(String var1);

        public Builder thumbnailWithStrings(Map<String, String> var1);

        public Builder thumbnail(Map<DocumentThumbnailType, String> var1);

        public Builder sourceWithStrings(Map<String, String> var1);

        public Builder source(Map<DocumentSourceType, String> var1);
    }
}

