/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateDocumentVersionUploadRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, InitiateDocumentVersionUploadRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::authenticationToken)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::id)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::name)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CONTENT_CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ContentCreatedTimestamp").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::contentCreatedTimestamp)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::contentCreatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentCreatedTimestamp").build()}).build();
    private static final SdkField<Instant> CONTENT_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ContentModifiedTimestamp").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::contentModifiedTimestamp)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::contentModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentModifiedTimestamp").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::contentType)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<Long> DOCUMENT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DocumentSizeInBytes").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::documentSizeInBytes)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::documentSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSizeInBytes").build()}).build();
    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentFolderId").getter(InitiateDocumentVersionUploadRequest.getter(InitiateDocumentVersionUploadRequest::parentFolderId)).setter(InitiateDocumentVersionUploadRequest.setter(Builder::parentFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, ID_FIELD, NAME_FIELD, CONTENT_CREATED_TIMESTAMP_FIELD, CONTENT_MODIFIED_TIMESTAMP_FIELD, CONTENT_TYPE_FIELD, DOCUMENT_SIZE_IN_BYTES_FIELD, PARENT_FOLDER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ContentCreatedTimestamp", CONTENT_CREATED_TIMESTAMP_FIELD);
            this.put("ContentModifiedTimestamp", CONTENT_MODIFIED_TIMESTAMP_FIELD);
            this.put("ContentType", CONTENT_TYPE_FIELD);
            this.put("DocumentSizeInBytes", DOCUMENT_SIZE_IN_BYTES_FIELD);
            this.put("ParentFolderId", PARENT_FOLDER_ID_FIELD);
        }
    });
    private final String authenticationToken;
    private final String id;
    private final String name;
    private final Instant contentCreatedTimestamp;
    private final Instant contentModifiedTimestamp;
    private final String contentType;
    private final Long documentSizeInBytes;
    private final String parentFolderId;

    private InitiateDocumentVersionUploadRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.id = builder.id;
        this.name = builder.name;
        this.contentCreatedTimestamp = builder.contentCreatedTimestamp;
        this.contentModifiedTimestamp = builder.contentModifiedTimestamp;
        this.contentType = builder.contentType;
        this.documentSizeInBytes = builder.documentSizeInBytes;
        this.parentFolderId = builder.parentFolderId;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Instant contentCreatedTimestamp() {
        return this.contentCreatedTimestamp;
    }

    public final Instant contentModifiedTimestamp() {
        return this.contentModifiedTimestamp;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final Long documentSizeInBytes() {
        return this.documentSizeInBytes;
    }

    public final String parentFolderId() {
        return this.parentFolderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentCreatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFolderId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateDocumentVersionUploadRequest)) {
            return false;
        }
        InitiateDocumentVersionUploadRequest other = (InitiateDocumentVersionUploadRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.contentCreatedTimestamp(), other.contentCreatedTimestamp()) && Objects.equals(this.contentModifiedTimestamp(), other.contentModifiedTimestamp()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.documentSizeInBytes(), other.documentSizeInBytes()) && Objects.equals(this.parentFolderId(), other.parentFolderId());
    }

    public final String toString() {
        return ToString.builder((String)"InitiateDocumentVersionUploadRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentCreatedTimestamp", (Object)this.contentCreatedTimestamp()).add("ContentModifiedTimestamp", (Object)this.contentModifiedTimestamp()).add("ContentType", (Object)this.contentType()).add("DocumentSizeInBytes", (Object)this.documentSizeInBytes()).add("ParentFolderId", (Object)this.parentFolderId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ContentCreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.contentCreatedTimestamp()));
            }
            case "ContentModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.contentModifiedTimestamp()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "DocumentSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.documentSizeInBytes()));
            }
            case "ParentFolderId": {
                return Optional.ofNullable(clazz.cast(this.parentFolderId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InitiateDocumentVersionUploadRequest, T> g) {
        return obj -> g.apply((InitiateDocumentVersionUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String id;
        private String name;
        private Instant contentCreatedTimestamp;
        private Instant contentModifiedTimestamp;
        private String contentType;
        private Long documentSizeInBytes;
        private String parentFolderId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateDocumentVersionUploadRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.id(model.id);
            this.name(model.name);
            this.contentCreatedTimestamp(model.contentCreatedTimestamp);
            this.contentModifiedTimestamp(model.contentModifiedTimestamp);
            this.contentType(model.contentType);
            this.documentSizeInBytes(model.documentSizeInBytes);
            this.parentFolderId(model.parentFolderId);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getContentCreatedTimestamp() {
            return this.contentCreatedTimestamp;
        }

        public final void setContentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
        }

        @Override
        public final Builder contentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
            return this;
        }

        public final Instant getContentModifiedTimestamp() {
            return this.contentModifiedTimestamp;
        }

        public final void setContentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
        }

        @Override
        public final Builder contentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Long getDocumentSizeInBytes() {
            return this.documentSizeInBytes;
        }

        public final void setDocumentSizeInBytes(Long documentSizeInBytes) {
            this.documentSizeInBytes = documentSizeInBytes;
        }

        @Override
        public final Builder documentSizeInBytes(Long documentSizeInBytes) {
            this.documentSizeInBytes = documentSizeInBytes;
            return this;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitiateDocumentVersionUploadRequest build() {
            return new InitiateDocumentVersionUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InitiateDocumentVersionUploadRequest> {
        public Builder authenticationToken(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder contentCreatedTimestamp(Instant var1);

        public Builder contentModifiedTimestamp(Instant var1);

        public Builder contentType(String var1);

        public Builder documentSizeInBytes(Long var1);

        public Builder parentFolderId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

