/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationOptions> {
    private static final SdkField<Boolean> SEND_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SendEmail").getter(NotificationOptions.getter(NotificationOptions::sendEmail)).setter(NotificationOptions.setter(Builder::sendEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendEmail").build()}).build();
    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailMessage").getter(NotificationOptions.getter(NotificationOptions::emailMessage)).setter(NotificationOptions.setter(Builder::emailMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_EMAIL_FIELD, EMAIL_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SendEmail", SEND_EMAIL_FIELD);
            this.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean sendEmail;
    private final String emailMessage;

    private NotificationOptions(BuilderImpl builder) {
        this.sendEmail = builder.sendEmail;
        this.emailMessage = builder.emailMessage;
    }

    public final Boolean sendEmail() {
        return this.sendEmail;
    }

    public final String emailMessage() {
        return this.emailMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sendEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions other = (NotificationOptions)obj;
        return Objects.equals(this.sendEmail(), other.sendEmail()) && Objects.equals(this.emailMessage(), other.emailMessage());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationOptions").add("SendEmail", (Object)this.sendEmail()).add("EmailMessage", (Object)(this.emailMessage() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendEmail": {
                return Optional.ofNullable(clazz.cast(this.sendEmail()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotificationOptions, T> g) {
        return obj -> g.apply((NotificationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean sendEmail;
        private String emailMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationOptions model) {
            this.sendEmail(model.sendEmail);
            this.emailMessage(model.emailMessage);
        }

        public final Boolean getSendEmail() {
            return this.sendEmail;
        }

        public final void setSendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
        }

        @Override
        public final Builder sendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
            return this;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public NotificationOptions build() {
            return new NotificationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationOptions> {
        public Builder sendEmail(Boolean var1);

        public Builder emailMessage(String var1);
    }
}

