/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContentCategoryType {
    IMAGE("IMAGE"),
    DOCUMENT("DOCUMENT"),
    PDF("PDF"),
    SPREADSHEET("SPREADSHEET"),
    PRESENTATION("PRESENTATION"),
    AUDIO("AUDIO"),
    VIDEO("VIDEO"),
    SOURCE_CODE("SOURCE_CODE"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContentCategoryType> VALUE_MAP;
    private final String value;

    private ContentCategoryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentCategoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentCategoryType> knownValues() {
        EnumSet<ContentCategoryType> knownValues = EnumSet.allOf(ContentCategoryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContentCategoryType.class, ContentCategoryType::toString);
    }
}

