/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionInfo implements SdkPojo, Serializable, ToCopyableBuilder<PermissionInfo.Builder, PermissionInfo> {
    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(PermissionInfo::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PermissionInfo::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String role;

    private final String type;

    private PermissionInfo(BuilderImpl builder) {
        this.role = builder.role;
        this.type = builder.type;
    }

    /**
     * <p>
     * The role of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the user.
     * @see RoleType
     */
    public final RoleType role() {
        return RoleType.fromValue(role);
    }

    /**
     * <p>
     * The role of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the user.
     * @see RoleType
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The type of permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RolePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of permissions.
     * @see RolePermissionType
     */
    public final RolePermissionType type() {
        return RolePermissionType.fromValue(type);
    }

    /**
     * <p>
     * The type of permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RolePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of permissions.
     * @see RolePermissionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo other = (PermissionInfo) obj;
        return Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionInfo").add("Role", roleAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionInfo, T> g) {
        return obj -> g.apply((PermissionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionInfo> {
        /**
         * <p>
         * The role of the user.
         * </p>
         * 
         * @param role
         *        The role of the user.
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder role(String role);

        /**
         * <p>
         * The role of the user.
         * </p>
         * 
         * @param role
         *        The role of the user.
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder role(RoleType role);

        /**
         * <p>
         * The type of permissions.
         * </p>
         * 
         * @param type
         *        The type of permissions.
         * @see RolePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RolePermissionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of permissions.
         * </p>
         * 
         * @param type
         *        The type of permissions.
         * @see RolePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RolePermissionType
         */
        Builder type(RolePermissionType type);
    }

    static final class BuilderImpl implements Builder {
        private String role;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionInfo model) {
            role(model.role);
            type(model.type);
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RolePermissionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public PermissionInfo build() {
            return new PermissionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
