/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;

public class DescribeActivitiesIterable
implements SdkIterable<DescribeActivitiesResponse> {
    private final WorkDocsClient client;
    private final DescribeActivitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeActivitiesIterable(WorkDocsClient client, DescribeActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeActivitiesResponseFetcher();
    }

    public Iterator<DescribeActivitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Activity> userActivities() {
        Function<DescribeActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.userActivities() != null) {
                return response.userActivities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeActivitiesResponseFetcher
    implements SyncPageFetcher<DescribeActivitiesResponse> {
        private DescribeActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeActivitiesResponse nextPage(DescribeActivitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivitiesIterable.this.client.describeActivities(DescribeActivitiesIterable.this.firstRequest);
            }
            return DescribeActivitiesIterable.this.client.describeActivities((DescribeActivitiesRequest)((Object)DescribeActivitiesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

