/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workdocs.DefaultWorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.DefaultWorkDocsBaseClientBuilder;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClientBuilder;
import software.amazon.awssdk.services.workdocs.WorkDocsServiceClientConfiguration;
import software.amazon.awssdk.services.workdocs.endpoints.WorkDocsEndpointProvider;

@SdkInternalApi
final class DefaultWorkDocsAsyncClientBuilder
extends DefaultWorkDocsBaseClientBuilder<WorkDocsAsyncClientBuilder, WorkDocsAsyncClient>
implements WorkDocsAsyncClientBuilder {
    DefaultWorkDocsAsyncClientBuilder() {
    }

    @Override
    public DefaultWorkDocsAsyncClientBuilder endpointProvider(WorkDocsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkDocsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWorkDocsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WorkDocsServiceClientConfiguration serviceClientConfiguration = WorkDocsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWorkDocsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

