/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.CommentVisibilityType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCommentRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, CreateCommentRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(CreateCommentRequest.getter(CreateCommentRequest::authenticationToken)).setter(CreateCommentRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(CreateCommentRequest.getter(CreateCommentRequest::documentId)).setter(CreateCommentRequest.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(CreateCommentRequest.getter(CreateCommentRequest::versionId)).setter(CreateCommentRequest.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionId").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentId").getter(CreateCommentRequest.getter(CreateCommentRequest::parentId)).setter(CreateCommentRequest.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> THREAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThreadId").getter(CreateCommentRequest.getter(CreateCommentRequest::threadId)).setter(CreateCommentRequest.setter(Builder::threadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(CreateCommentRequest.getter(CreateCommentRequest::text)).setter(CreateCommentRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(CreateCommentRequest.getter(CreateCommentRequest::visibilityAsString)).setter(CreateCommentRequest.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<Boolean> NOTIFY_COLLABORATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NotifyCollaborators").getter(CreateCommentRequest.getter(CreateCommentRequest::notifyCollaborators)).setter(CreateCommentRequest.setter(Builder::notifyCollaborators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyCollaborators").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, DOCUMENT_ID_FIELD, VERSION_ID_FIELD, PARENT_ID_FIELD, THREAD_ID_FIELD, TEXT_FIELD, VISIBILITY_FIELD, NOTIFY_COLLABORATORS_FIELD));
    private final String authenticationToken;
    private final String documentId;
    private final String versionId;
    private final String parentId;
    private final String threadId;
    private final String text;
    private final String visibility;
    private final Boolean notifyCollaborators;

    private CreateCommentRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.visibility = builder.visibility;
        this.notifyCollaborators = builder.notifyCollaborators;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final String parentId() {
        return this.parentId;
    }

    public final String threadId() {
        return this.threadId;
    }

    public final String text() {
        return this.text;
    }

    public final CommentVisibilityType visibility() {
        return CommentVisibilityType.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final Boolean notifyCollaborators() {
        return this.notifyCollaborators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifyCollaborators());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommentRequest)) {
            return false;
        }
        CreateCommentRequest other = (CreateCommentRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.threadId(), other.threadId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.notifyCollaborators(), other.notifyCollaborators());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCommentRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DocumentId", (Object)this.documentId()).add("VersionId", (Object)this.versionId()).add("ParentId", (Object)this.parentId()).add("ThreadId", (Object)this.threadId()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("Visibility", (Object)this.visibilityAsString()).add("NotifyCollaborators", (Object)this.notifyCollaborators()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "ThreadId": {
                return Optional.ofNullable(clazz.cast(this.threadId()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "NotifyCollaborators": {
                return Optional.ofNullable(clazz.cast(this.notifyCollaborators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCommentRequest, T> g) {
        return obj -> g.apply((CreateCommentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String versionId;
        private String parentId;
        private String threadId;
        private String text;
        private String visibility;
        private Boolean notifyCollaborators;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommentRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.versionId(model.versionId);
            this.parentId(model.parentId);
            this.threadId(model.threadId);
            this.text(model.text);
            this.visibility(model.visibility);
            this.notifyCollaborators(model.notifyCollaborators);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        @Transient
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        @Transient
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        @Transient
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        @Transient
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getThreadId() {
            return this.threadId;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        @Override
        @Transient
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        @Transient
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        @Transient
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final Boolean getNotifyCollaborators() {
            return this.notifyCollaborators;
        }

        public final void setNotifyCollaborators(Boolean notifyCollaborators) {
            this.notifyCollaborators = notifyCollaborators;
        }

        @Override
        @Transient
        public final Builder notifyCollaborators(Boolean notifyCollaborators) {
            this.notifyCollaborators = notifyCollaborators;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCommentRequest build() {
            return new CreateCommentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCommentRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder versionId(String var1);

        public Builder parentId(String var1);

        public Builder threadId(String var1);

        public Builder text(String var1);

        public Builder visibility(String var1);

        public Builder visibility(CommentVisibilityType var1);

        public Builder notifyCollaborators(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

