/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SubscriptionProtocolType {
    HTTPS("HTTPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SubscriptionProtocolType> VALUE_MAP;
    private final String value;

    private SubscriptionProtocolType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SubscriptionProtocolType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SubscriptionProtocolType> knownValues() {
        EnumSet<SubscriptionProtocolType> knownValues = EnumSet.allOf(SubscriptionProtocolType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SubscriptionProtocolType.class, SubscriptionProtocolType::toString);
    }
}

