/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, GetDocumentResponse> {
    private static final SdkField<DocumentMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(GetDocumentResponse.getter(GetDocumentResponse::metadata)).setter(GetDocumentResponse.setter(Builder::metadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomMetadata").getter(GetDocumentResponse.getter(GetDocumentResponse::customMetadata)).setter(GetDocumentResponse.setter(Builder::customMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, CUSTOM_METADATA_FIELD));
    private final DocumentMetadata metadata;
    private final Map<String, String> customMetadata;

    private GetDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    public final DocumentMetadata metadata() {
        return this.metadata;
    }

    public final boolean hasCustomMetadata() {
        return this.customMetadata != null && !(this.customMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomMetadata() ? this.customMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentResponse)) {
            return false;
        }
        GetDocumentResponse other = (GetDocumentResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && this.hasCustomMetadata() == other.hasCustomMetadata() && Objects.equals(this.customMetadata(), other.customMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetDocumentResponse").add("Metadata", (Object)this.metadata()).add("CustomMetadata", this.hasCustomMetadata() ? this.customMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "CustomMetadata": {
                return Optional.ofNullable(clazz.cast(this.customMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentResponse, T> g) {
        return obj -> g.apply((GetDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata metadata;
        private Map<String, String> customMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentResponse model) {
            super(model);
            this.metadata(model.metadata);
            this.customMetadata(model.customMetadata);
        }

        public final DocumentMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(DocumentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Map<String, String> getCustomMetadata() {
            if (this.customMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        @Override
        public GetDocumentResponse build() {
            return new GetDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDocumentResponse> {
        public Builder metadata(DocumentMetadata var1);

        default public Builder metadata(Consumer<DocumentMetadata.Builder> metadata) {
            return this.metadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder customMetadata(Map<String, String> var1);
    }
}

