/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

public class DescribeDocumentVersionsPublisher
implements SdkPublisher<DescribeDocumentVersionsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeDocumentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDocumentVersionsPublisher(WorkDocsAsyncClient client, DescribeDocumentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDocumentVersionsPublisher(WorkDocsAsyncClient client, DescribeDocumentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDocumentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDocumentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DocumentVersionMetadata> documentVersions() {
        Function<DescribeDocumentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentVersions() != null) {
                return response.documentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDocumentVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDocumentVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeDocumentVersionsResponse> {
        private DescribeDocumentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDocumentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDocumentVersionsResponse> nextPage(DescribeDocumentVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDocumentVersionsPublisher.this.client.describeDocumentVersions(DescribeDocumentVersionsPublisher.this.firstRequest);
            }
            return DescribeDocumentVersionsPublisher.this.client.describeDocumentVersions((DescribeDocumentVersionsRequest)((Object)DescribeDocumentVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

