/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RoleType {
    VIEWER("VIEWER"),
    CONTRIBUTOR("CONTRIBUTOR"),
    OWNER("OWNER"),
    COOWNER("COOWNER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RoleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RoleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoleType> knownValues() {
        return Stream.of(RoleType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

