/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeGroupsRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(DescribeGroupsRequest.getter(DescribeGroupsRequest::authenticationToken)).setter(DescribeGroupsRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> SEARCH_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchQuery").getter(DescribeGroupsRequest.getter(DescribeGroupsRequest::searchQuery)).setter(DescribeGroupsRequest.setter(Builder::searchQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("searchQuery").build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(DescribeGroupsRequest.getter(DescribeGroupsRequest::organizationId)).setter(DescribeGroupsRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationId").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeGroupsRequest.getter(DescribeGroupsRequest::marker)).setter(DescribeGroupsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeGroupsRequest.getter(DescribeGroupsRequest::limit)).setter(DescribeGroupsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, SEARCH_QUERY_FIELD, ORGANIZATION_ID_FIELD, MARKER_FIELD, LIMIT_FIELD));
    private final String authenticationToken;
    private final String searchQuery;
    private final String organizationId;
    private final String marker;
    private final Integer limit;

    private DescribeGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.searchQuery = builder.searchQuery;
        this.organizationId = builder.organizationId;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String searchQuery() {
        return this.searchQuery;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupsRequest)) {
            return false;
        }
        DescribeGroupsRequest other = (DescribeGroupsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.searchQuery(), other.searchQuery()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGroupsRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("SearchQuery", (Object)(this.searchQuery() == null ? null : "*** Sensitive Data Redacted ***")).add("OrganizationId", (Object)this.organizationId()).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "SearchQuery": {
                return Optional.ofNullable(clazz.cast(this.searchQuery()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupsRequest, T> g) {
        return obj -> g.apply((DescribeGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String searchQuery;
        private String organizationId;
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupsRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.searchQuery(model.searchQuery);
            this.organizationId(model.organizationId);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getSearchQuery() {
            return this.searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGroupsRequest build() {
            return new DescribeGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupsRequest> {
        public Builder authenticationToken(String var1);

        public Builder searchQuery(String var1);

        public Builder organizationId(String var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

