/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.CommentVisibilityType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCommentRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, CreateCommentRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::authenticationToken)).setter(CreateCommentRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::documentId)).setter(CreateCommentRequest.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::versionId)).setter(CreateCommentRequest.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionId").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::parentId)).setter(CreateCommentRequest.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> THREAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::threadId)).setter(CreateCommentRequest.setter(Builder::threadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::text)).setter(CreateCommentRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommentRequest.getter(CreateCommentRequest::visibilityAsString)).setter(CreateCommentRequest.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<Boolean> NOTIFY_COLLABORATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateCommentRequest.getter(CreateCommentRequest::notifyCollaborators)).setter(CreateCommentRequest.setter(Builder::notifyCollaborators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyCollaborators").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, DOCUMENT_ID_FIELD, VERSION_ID_FIELD, PARENT_ID_FIELD, THREAD_ID_FIELD, TEXT_FIELD, VISIBILITY_FIELD, NOTIFY_COLLABORATORS_FIELD));
    private final String authenticationToken;
    private final String documentId;
    private final String versionId;
    private final String parentId;
    private final String threadId;
    private final String text;
    private final String visibility;
    private final Boolean notifyCollaborators;

    private CreateCommentRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.visibility = builder.visibility;
        this.notifyCollaborators = builder.notifyCollaborators;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public String versionId() {
        return this.versionId;
    }

    public String parentId() {
        return this.parentId;
    }

    public String threadId() {
        return this.threadId;
    }

    public String text() {
        return this.text;
    }

    public CommentVisibilityType visibility() {
        return CommentVisibilityType.fromValue(this.visibility);
    }

    public String visibilityAsString() {
        return this.visibility;
    }

    public Boolean notifyCollaborators() {
        return this.notifyCollaborators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifyCollaborators());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommentRequest)) {
            return false;
        }
        CreateCommentRequest other = (CreateCommentRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.threadId(), other.threadId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.notifyCollaborators(), other.notifyCollaborators());
    }

    public String toString() {
        return ToString.builder((String)"CreateCommentRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DocumentId", (Object)this.documentId()).add("VersionId", (Object)this.versionId()).add("ParentId", (Object)this.parentId()).add("ThreadId", (Object)this.threadId()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("Visibility", (Object)this.visibilityAsString()).add("NotifyCollaborators", (Object)this.notifyCollaborators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "ThreadId": {
                return Optional.ofNullable(clazz.cast(this.threadId()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "NotifyCollaborators": {
                return Optional.ofNullable(clazz.cast(this.notifyCollaborators()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCommentRequest, T> g) {
        return obj -> g.apply((CreateCommentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String versionId;
        private String parentId;
        private String threadId;
        private String text;
        private String visibility;
        private Boolean notifyCollaborators;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommentRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.versionId(model.versionId);
            this.parentId(model.parentId);
            this.threadId(model.threadId);
            this.text(model.text);
            this.visibility(model.visibility);
            this.notifyCollaborators(model.notifyCollaborators);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getThreadId() {
            return this.threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final Boolean getNotifyCollaborators() {
            return this.notifyCollaborators;
        }

        @Override
        public final Builder notifyCollaborators(Boolean notifyCollaborators) {
            this.notifyCollaborators = notifyCollaborators;
            return this;
        }

        public final void setNotifyCollaborators(Boolean notifyCollaborators) {
            this.notifyCollaborators = notifyCollaborators;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCommentRequest build() {
            return new CreateCommentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCommentRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder versionId(String var1);

        public Builder parentId(String var1);

        public Builder threadId(String var1);

        public Builder text(String var1);

        public Builder visibility(String var1);

        public Builder visibility(CommentVisibilityType var1);

        public Builder notifyCollaborators(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

