/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;

public class DescribeFolderContentsIterable
implements SdkIterable<DescribeFolderContentsResponse> {
    private final WorkDocsClient client;
    private final DescribeFolderContentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFolderContentsIterable(WorkDocsClient client, DescribeFolderContentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFolderContentsResponseFetcher();
    }

    public Iterator<DescribeFolderContentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FolderMetadata> folders() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.folders() != null) {
                return response.folders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<DocumentMetadata> documents() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documents() != null) {
                return response.documents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFolderContentsResponseFetcher
    implements SyncPageFetcher<DescribeFolderContentsResponse> {
        private DescribeFolderContentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFolderContentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeFolderContentsResponse nextPage(DescribeFolderContentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFolderContentsIterable.this.client.describeFolderContents(DescribeFolderContentsIterable.this.firstRequest);
            }
            return DescribeFolderContentsIterable.this.client.describeFolderContents((DescribeFolderContentsRequest)((Object)DescribeFolderContentsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

