/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationOptions> {
    private static final SdkField<Boolean> SEND_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(NotificationOptions.getter(NotificationOptions::sendEmail)).setter(NotificationOptions.setter(Builder::sendEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendEmail").build()}).build();
    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationOptions.getter(NotificationOptions::emailMessage)).setter(NotificationOptions.setter(Builder::emailMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_EMAIL_FIELD, EMAIL_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean sendEmail;
    private final String emailMessage;

    private NotificationOptions(BuilderImpl builder) {
        this.sendEmail = builder.sendEmail;
        this.emailMessage = builder.emailMessage;
    }

    public Boolean sendEmail() {
        return this.sendEmail;
    }

    public String emailMessage() {
        return this.emailMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sendEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions other = (NotificationOptions)obj;
        return Objects.equals(this.sendEmail(), other.sendEmail()) && Objects.equals(this.emailMessage(), other.emailMessage());
    }

    public String toString() {
        return ToString.builder((String)"NotificationOptions").add("SendEmail", (Object)this.sendEmail()).add("EmailMessage", (Object)(this.emailMessage() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendEmail": {
                return Optional.ofNullable(clazz.cast(this.sendEmail()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationOptions, T> g) {
        return obj -> g.apply((NotificationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean sendEmail;
        private String emailMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationOptions model) {
            this.sendEmail(model.sendEmail);
            this.emailMessage(model.emailMessage);
        }

        public final Boolean getSendEmail() {
            return this.sendEmail;
        }

        @Override
        public final Builder sendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
            return this;
        }

        public final void setSendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        public NotificationOptions build() {
            return new NotificationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationOptions> {
        public Builder sendEmail(Boolean var1);

        public Builder emailMessage(String var1);
    }
}

