/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.PermissionInfo;
import software.amazon.awssdk.services.workdocs.model.PermissionInfoListCopier;
import software.amazon.awssdk.services.workdocs.model.PrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Principal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Principal> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Principal.getter(Principal::id)).setter(Principal.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Principal.getter(Principal::typeAsString)).setter(Principal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<PermissionInfo>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Principal.getter(Principal::roles)).setter(Principal.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermissionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, ROLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final List<PermissionInfo> roles;

    private Principal(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.roles = builder.roles;
    }

    public String id() {
        return this.id;
    }

    public PrincipalType type() {
        return PrincipalType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public List<PermissionInfo> roles() {
        return this.roles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.roles(), other.roles());
    }

    public String toString() {
        return ToString.builder((String)"Principal").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Roles", this.roles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Principal, T> g) {
        return obj -> g.apply((Principal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private List<PermissionInfo> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            this.id(model.id);
            this.type(model.type);
            this.roles(model.roles);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrincipalType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<PermissionInfo.Builder> getRoles() {
            return this.roles != null ? (Collection)this.roles.stream().map(PermissionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<PermissionInfo> roles) {
            this.roles = PermissionInfoListCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(PermissionInfo ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<PermissionInfo.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (PermissionInfo)((PermissionInfo.Builder)PermissionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoles(Collection<PermissionInfo.BuilderImpl> roles) {
            this.roles = PermissionInfoListCopier.copyFromBuilder(roles);
        }

        public Principal build() {
            return new Principal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Principal> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(PrincipalType var1);

        public Builder roles(Collection<PermissionInfo> var1);

        public Builder roles(PermissionInfo ... var1);

        public Builder roles(Consumer<PermissionInfo.Builder> ... var1);
    }
}

