/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateCommentRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("DocumentId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentId").isBinary(false).build();
    private static final MarshallingInfo<String> THREADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThreadId").isBinary(false).build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<String> VISIBILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Visibility").isBinary(false).build();
    private static final MarshallingInfo<Boolean> NOTIFYCOLLABORATORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotifyCollaborators").isBinary(false).build();
    private static final CreateCommentRequestModelMarshaller INSTANCE = new CreateCommentRequestModelMarshaller();

    private CreateCommentRequestModelMarshaller() {
    }

    public static CreateCommentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateCommentRequest createCommentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createCommentRequest), (String)"createCommentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createCommentRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.documentId(), DOCUMENTID_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.parentId(), PARENTID_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.threadId(), THREADID_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.visibilityString(), VISIBILITY_BINDING);
            protocolMarshaller.marshall((Object)createCommentRequest.notifyCollaborators(), NOTIFYCOLLABORATORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

