/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.model.ResourceMetadata;
import software.amazon.awssdk.services.workdocs.transform.UserMetadataUnmarshaller;

public class ResourceMetadataUnmarshaller
implements Unmarshaller<ResourceMetadata, JsonUnmarshallerContext> {
    private static final ResourceMetadataUnmarshaller INSTANCE = new ResourceMetadataUnmarshaller();

    public ResourceMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceMetadata.Builder resourceMetadataBuilder = ResourceMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OriginalName", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.originalName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.versionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.owner(UserMetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ParentId", targetDepth)) {
                    context.nextToken();
                    resourceMetadataBuilder.parentId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceMetadata)resourceMetadataBuilder.build();
    }

    public static ResourceMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

