/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.LocaleType;
import software.amazon.awssdk.services.workdocs.model.UserStatusType;
import software.amazon.awssdk.services.workdocs.model.UserStorageMetadata;
import software.amazon.awssdk.services.workdocs.model.UserType;
import software.amazon.awssdk.services.workdocs.transform.UserMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class User
implements StructuredPojo,
ToCopyableBuilder<Builder, User> {
    private final String id;
    private final String username;
    private final String emailAddress;
    private final String givenName;
    private final String surname;
    private final String organizationId;
    private final String rootFolderId;
    private final String recycleBinFolderId;
    private final String status;
    private final String type;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final String timeZoneId;
    private final String locale;
    private final UserStorageMetadata storage;

    private User(BuilderImpl builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.organizationId = builder.organizationId;
        this.rootFolderId = builder.rootFolderId;
        this.recycleBinFolderId = builder.recycleBinFolderId;
        this.status = builder.status;
        this.type = builder.type;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.timeZoneId = builder.timeZoneId;
        this.locale = builder.locale;
        this.storage = builder.storage;
    }

    public String id() {
        return this.id;
    }

    public String username() {
        return this.username;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String givenName() {
        return this.givenName;
    }

    public String surname() {
        return this.surname;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String rootFolderId() {
        return this.rootFolderId;
    }

    public String recycleBinFolderId() {
        return this.recycleBinFolderId;
    }

    public UserStatusType status() {
        return UserStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public UserType type() {
        return UserType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public LocaleType locale() {
        return LocaleType.fromValue(this.locale);
    }

    public String localeString() {
        return this.locale;
    }

    public UserStorageMetadata storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recycleBinFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.rootFolderId(), other.rootFolderId()) && Objects.equals(this.recycleBinFolderId(), other.recycleBinFolderId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.localeString(), other.localeString()) && Objects.equals(this.storage(), other.storage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.emailAddress() != null) {
            sb.append("EmailAddress: ").append(this.emailAddress()).append(",");
        }
        if (this.givenName() != null) {
            sb.append("GivenName: ").append(this.givenName()).append(",");
        }
        if (this.surname() != null) {
            sb.append("Surname: ").append(this.surname()).append(",");
        }
        if (this.organizationId() != null) {
            sb.append("OrganizationId: ").append(this.organizationId()).append(",");
        }
        if (this.rootFolderId() != null) {
            sb.append("RootFolderId: ").append(this.rootFolderId()).append(",");
        }
        if (this.recycleBinFolderId() != null) {
            sb.append("RecycleBinFolderId: ").append(this.recycleBinFolderId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.modifiedTimestamp() != null) {
            sb.append("ModifiedTimestamp: ").append(this.modifiedTimestamp()).append(",");
        }
        if (this.timeZoneId() != null) {
            sb.append("TimeZoneId: ").append(this.timeZoneId()).append(",");
        }
        if (this.localeString() != null) {
            sb.append("Locale: ").append(this.localeString()).append(",");
        }
        if (this.storage() != null) {
            sb.append("Storage: ").append(this.storage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
            case "EmailAddress": {
                return Optional.of(clazz.cast(this.emailAddress()));
            }
            case "GivenName": {
                return Optional.of(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.of(clazz.cast(this.surname()));
            }
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
            case "RootFolderId": {
                return Optional.of(clazz.cast(this.rootFolderId()));
            }
            case "RecycleBinFolderId": {
                return Optional.of(clazz.cast(this.recycleBinFolderId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "CreatedTimestamp": {
                return Optional.of(clazz.cast(this.createdTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.of(clazz.cast(this.modifiedTimestamp()));
            }
            case "TimeZoneId": {
                return Optional.of(clazz.cast(this.timeZoneId()));
            }
            case "Locale": {
                return Optional.of(clazz.cast(this.localeString()));
            }
            case "Storage": {
                return Optional.of(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String username;
        private String emailAddress;
        private String givenName;
        private String surname;
        private String organizationId;
        private String rootFolderId;
        private String recycleBinFolderId;
        private String status;
        private String type;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private String timeZoneId;
        private String locale;
        private UserStorageMetadata storage;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.id(model.id);
            this.username(model.username);
            this.emailAddress(model.emailAddress);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.organizationId(model.organizationId);
            this.rootFolderId(model.rootFolderId);
            this.recycleBinFolderId(model.recycleBinFolderId);
            this.status(model.status);
            this.type(model.type);
            this.createdTimestamp(model.createdTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.timeZoneId(model.timeZoneId);
            this.locale(model.locale);
            this.storage(model.storage);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public final String getSurname() {
            return this.surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getRootFolderId() {
            return this.rootFolderId;
        }

        @Override
        public final Builder rootFolderId(String rootFolderId) {
            this.rootFolderId = rootFolderId;
            return this;
        }

        public final void setRootFolderId(String rootFolderId) {
            this.rootFolderId = rootFolderId;
        }

        public final String getRecycleBinFolderId() {
            return this.recycleBinFolderId;
        }

        @Override
        public final Builder recycleBinFolderId(String recycleBinFolderId) {
            this.recycleBinFolderId = recycleBinFolderId;
            return this;
        }

        public final void setRecycleBinFolderId(String recycleBinFolderId) {
            this.recycleBinFolderId = recycleBinFolderId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleType locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final UserStorageMetadata.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(UserStorageMetadata storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(UserStorageMetadata.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public User build() {
            return new User(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, User> {
        public Builder id(String var1);

        public Builder username(String var1);

        public Builder emailAddress(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder organizationId(String var1);

        public Builder rootFolderId(String var1);

        public Builder recycleBinFolderId(String var1);

        public Builder status(String var1);

        public Builder status(UserStatusType var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder timeZoneId(String var1);

        public Builder locale(String var1);

        public Builder locale(LocaleType var1);

        public Builder storage(UserStorageMetadata var1);

        default public Builder storage(Consumer<UserStorageMetadata.Builder> storage) {
            return this.storage((UserStorageMetadata)((UserStorageMetadata.Builder)UserStorageMetadata.builder().apply(storage)).build());
        }
    }
}

