/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.User;

public final class DescribeUsersPaginator
implements SdkIterable<DescribeUsersResponse> {
    private final WorkDocsClient client;
    private final DescribeUsersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeUsersPaginator(WorkDocsClient client, DescribeUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeUsersResponseFetcher();
    }

    public Iterator<DescribeUsersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<User> users() {
        Function<DescribeUsersResponse, Iterator> getIterator = response -> response != null ? response.users().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeUsersResponseFetcher
    implements NextPageFetcher<DescribeUsersResponse> {
        private DescribeUsersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUsersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeUsersResponse nextPage(DescribeUsersResponse previousPage) {
            if (previousPage == null) {
                return DescribeUsersPaginator.this.client.describeUsers(DescribeUsersPaginator.this.firstRequest);
            }
            return DescribeUsersPaginator.this.client.describeUsers((DescribeUsersRequest)((Object)DescribeUsersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

