/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitiateDocumentVersionUploadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, InitiateDocumentVersionUploadRequest> {
    private final String authenticationToken;
    private final String id;
    private final String name;
    private final Instant contentCreatedTimestamp;
    private final Instant contentModifiedTimestamp;
    private final String contentType;
    private final Long documentSizeInBytes;
    private final String parentFolderId;

    private InitiateDocumentVersionUploadRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.id = builder.id;
        this.name = builder.name;
        this.contentCreatedTimestamp = builder.contentCreatedTimestamp;
        this.contentModifiedTimestamp = builder.contentModifiedTimestamp;
        this.contentType = builder.contentType;
        this.documentSizeInBytes = builder.documentSizeInBytes;
        this.parentFolderId = builder.parentFolderId;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Instant contentCreatedTimestamp() {
        return this.contentCreatedTimestamp;
    }

    public Instant contentModifiedTimestamp() {
        return this.contentModifiedTimestamp;
    }

    public String contentType() {
        return this.contentType;
    }

    public Long documentSizeInBytes() {
        return this.documentSizeInBytes;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.contentCreatedTimestamp() == null ? 0 : this.contentCreatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.contentModifiedTimestamp() == null ? 0 : this.contentModifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.contentType() == null ? 0 : this.contentType().hashCode());
        hashCode = 31 * hashCode + (this.documentSizeInBytes() == null ? 0 : this.documentSizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.parentFolderId() == null ? 0 : this.parentFolderId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateDocumentVersionUploadRequest)) {
            return false;
        }
        InitiateDocumentVersionUploadRequest other = (InitiateDocumentVersionUploadRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.contentCreatedTimestamp() == null ^ this.contentCreatedTimestamp() == null) {
            return false;
        }
        if (other.contentCreatedTimestamp() != null && !other.contentCreatedTimestamp().equals(this.contentCreatedTimestamp())) {
            return false;
        }
        if (other.contentModifiedTimestamp() == null ^ this.contentModifiedTimestamp() == null) {
            return false;
        }
        if (other.contentModifiedTimestamp() != null && !other.contentModifiedTimestamp().equals(this.contentModifiedTimestamp())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        if (other.documentSizeInBytes() == null ^ this.documentSizeInBytes() == null) {
            return false;
        }
        if (other.documentSizeInBytes() != null && !other.documentSizeInBytes().equals(this.documentSizeInBytes())) {
            return false;
        }
        if (other.parentFolderId() == null ^ this.parentFolderId() == null) {
            return false;
        }
        return other.parentFolderId() == null || other.parentFolderId().equals(this.parentFolderId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.contentCreatedTimestamp() != null) {
            sb.append("ContentCreatedTimestamp: ").append(this.contentCreatedTimestamp()).append(",");
        }
        if (this.contentModifiedTimestamp() != null) {
            sb.append("ContentModifiedTimestamp: ").append(this.contentModifiedTimestamp()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (this.documentSizeInBytes() != null) {
            sb.append("DocumentSizeInBytes: ").append(this.documentSizeInBytes()).append(",");
        }
        if (this.parentFolderId() != null) {
            sb.append("ParentFolderId: ").append(this.parentFolderId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ContentCreatedTimestamp": {
                return Optional.of(clazz.cast(this.contentCreatedTimestamp()));
            }
            case "ContentModifiedTimestamp": {
                return Optional.of(clazz.cast(this.contentModifiedTimestamp()));
            }
            case "ContentType": {
                return Optional.of(clazz.cast(this.contentType()));
            }
            case "DocumentSizeInBytes": {
                return Optional.of(clazz.cast(this.documentSizeInBytes()));
            }
            case "ParentFolderId": {
                return Optional.of(clazz.cast(this.parentFolderId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String id;
        private String name;
        private Instant contentCreatedTimestamp;
        private Instant contentModifiedTimestamp;
        private String contentType;
        private Long documentSizeInBytes;
        private String parentFolderId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateDocumentVersionUploadRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.id(model.id);
            this.name(model.name);
            this.contentCreatedTimestamp(model.contentCreatedTimestamp);
            this.contentModifiedTimestamp(model.contentModifiedTimestamp);
            this.contentType(model.contentType);
            this.documentSizeInBytes(model.documentSizeInBytes);
            this.parentFolderId(model.parentFolderId);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getContentCreatedTimestamp() {
            return this.contentCreatedTimestamp;
        }

        @Override
        public final Builder contentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
            return this;
        }

        public final void setContentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
        }

        public final Instant getContentModifiedTimestamp() {
            return this.contentModifiedTimestamp;
        }

        @Override
        public final Builder contentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
            return this;
        }

        public final void setContentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Long getDocumentSizeInBytes() {
            return this.documentSizeInBytes;
        }

        @Override
        public final Builder documentSizeInBytes(Long documentSizeInBytes) {
            this.documentSizeInBytes = documentSizeInBytes;
            return this;
        }

        public final void setDocumentSizeInBytes(Long documentSizeInBytes) {
            this.documentSizeInBytes = documentSizeInBytes;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public InitiateDocumentVersionUploadRequest build() {
            return new InitiateDocumentVersionUploadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InitiateDocumentVersionUploadRequest> {
        public Builder authenticationToken(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder contentCreatedTimestamp(Instant var1);

        public Builder contentModifiedTimestamp(Instant var1);

        public Builder contentType(String var1);

        public Builder documentSizeInBytes(Long var1);

        public Builder parentFolderId(String var1);
    }
}

