/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFolderRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetFolderRequest> {
    private final String authenticationToken;
    private final String folderId;
    private final Boolean includeCustomMetadata;

    private GetFolderRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.includeCustomMetadata = builder.includeCustomMetadata;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String folderId() {
        return this.folderId;
    }

    public Boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.folderId() == null ? 0 : this.folderId().hashCode());
        hashCode = 31 * hashCode + (this.includeCustomMetadata() == null ? 0 : this.includeCustomMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderRequest)) {
            return false;
        }
        GetFolderRequest other = (GetFolderRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.folderId() == null ^ this.folderId() == null) {
            return false;
        }
        if (other.folderId() != null && !other.folderId().equals(this.folderId())) {
            return false;
        }
        if (other.includeCustomMetadata() == null ^ this.includeCustomMetadata() == null) {
            return false;
        }
        return other.includeCustomMetadata() == null || other.includeCustomMetadata().equals(this.includeCustomMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.folderId() != null) {
            sb.append("FolderId: ").append(this.folderId()).append(",");
        }
        if (this.includeCustomMetadata() != null) {
            sb.append("IncludeCustomMetadata: ").append(this.includeCustomMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.of(clazz.cast(this.folderId()));
            }
            case "IncludeCustomMetadata": {
                return Optional.of(clazz.cast(this.includeCustomMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private Boolean includeCustomMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.includeCustomMetadata(model.includeCustomMetadata);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final Boolean getIncludeCustomMetadata() {
            return this.includeCustomMetadata;
        }

        @Override
        public final Builder includeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
            return this;
        }

        public final void setIncludeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
        }

        public GetFolderRequest build() {
            return new GetFolderRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFolderRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder includeCustomMetadata(Boolean var1);
    }
}

