/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ActivityType;
import software.amazon.awssdk.services.workdocs.model.CommentMetadata;
import software.amazon.awssdk.services.workdocs.model.Participants;
import software.amazon.awssdk.services.workdocs.model.ResourceMetadata;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.services.workdocs.transform.ActivityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Activity
implements StructuredPojo,
ToCopyableBuilder<Builder, Activity> {
    private final String type;
    private final Instant timeStamp;
    private final String organizationId;
    private final UserMetadata initiator;
    private final Participants participants;
    private final ResourceMetadata resourceMetadata;
    private final ResourceMetadata originalParent;
    private final CommentMetadata commentMetadata;

    private Activity(BuilderImpl builder) {
        this.type = builder.type;
        this.timeStamp = builder.timeStamp;
        this.organizationId = builder.organizationId;
        this.initiator = builder.initiator;
        this.participants = builder.participants;
        this.resourceMetadata = builder.resourceMetadata;
        this.originalParent = builder.originalParent;
        this.commentMetadata = builder.commentMetadata;
    }

    public ActivityType type() {
        return ActivityType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant timeStamp() {
        return this.timeStamp;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public UserMetadata initiator() {
        return this.initiator;
    }

    public Participants participants() {
        return this.participants;
    }

    public ResourceMetadata resourceMetadata() {
        return this.resourceMetadata;
    }

    public ResourceMetadata originalParent() {
        return this.originalParent;
    }

    public CommentMetadata commentMetadata() {
        return this.commentMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.timeStamp() == null ? 0 : this.timeStamp().hashCode());
        hashCode = 31 * hashCode + (this.organizationId() == null ? 0 : this.organizationId().hashCode());
        hashCode = 31 * hashCode + (this.initiator() == null ? 0 : this.initiator().hashCode());
        hashCode = 31 * hashCode + (this.participants() == null ? 0 : this.participants().hashCode());
        hashCode = 31 * hashCode + (this.resourceMetadata() == null ? 0 : this.resourceMetadata().hashCode());
        hashCode = 31 * hashCode + (this.originalParent() == null ? 0 : this.originalParent().hashCode());
        hashCode = 31 * hashCode + (this.commentMetadata() == null ? 0 : this.commentMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.timeStamp() == null ^ this.timeStamp() == null) {
            return false;
        }
        if (other.timeStamp() != null && !other.timeStamp().equals(this.timeStamp())) {
            return false;
        }
        if (other.organizationId() == null ^ this.organizationId() == null) {
            return false;
        }
        if (other.organizationId() != null && !other.organizationId().equals(this.organizationId())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        if (other.initiator() != null && !other.initiator().equals(this.initiator())) {
            return false;
        }
        if (other.participants() == null ^ this.participants() == null) {
            return false;
        }
        if (other.participants() != null && !other.participants().equals(this.participants())) {
            return false;
        }
        if (other.resourceMetadata() == null ^ this.resourceMetadata() == null) {
            return false;
        }
        if (other.resourceMetadata() != null && !other.resourceMetadata().equals(this.resourceMetadata())) {
            return false;
        }
        if (other.originalParent() == null ^ this.originalParent() == null) {
            return false;
        }
        if (other.originalParent() != null && !other.originalParent().equals(this.originalParent())) {
            return false;
        }
        if (other.commentMetadata() == null ^ this.commentMetadata() == null) {
            return false;
        }
        return other.commentMetadata() == null || other.commentMetadata().equals(this.commentMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.timeStamp() != null) {
            sb.append("TimeStamp: ").append(this.timeStamp()).append(",");
        }
        if (this.organizationId() != null) {
            sb.append("OrganizationId: ").append(this.organizationId()).append(",");
        }
        if (this.initiator() != null) {
            sb.append("Initiator: ").append(this.initiator()).append(",");
        }
        if (this.participants() != null) {
            sb.append("Participants: ").append(this.participants()).append(",");
        }
        if (this.resourceMetadata() != null) {
            sb.append("ResourceMetadata: ").append(this.resourceMetadata()).append(",");
        }
        if (this.originalParent() != null) {
            sb.append("OriginalParent: ").append(this.originalParent()).append(",");
        }
        if (this.commentMetadata() != null) {
            sb.append("CommentMetadata: ").append(this.commentMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "TimeStamp": {
                return Optional.of(clazz.cast(this.timeStamp()));
            }
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
            case "Initiator": {
                return Optional.of(clazz.cast(this.initiator()));
            }
            case "Participants": {
                return Optional.of(clazz.cast(this.participants()));
            }
            case "ResourceMetadata": {
                return Optional.of(clazz.cast(this.resourceMetadata()));
            }
            case "OriginalParent": {
                return Optional.of(clazz.cast(this.originalParent()));
            }
            case "CommentMetadata": {
                return Optional.of(clazz.cast(this.commentMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Instant timeStamp;
        private String organizationId;
        private UserMetadata initiator;
        private Participants participants;
        private ResourceMetadata resourceMetadata;
        private ResourceMetadata originalParent;
        private CommentMetadata commentMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            this.type(model.type);
            this.timeStamp(model.timeStamp);
            this.organizationId(model.organizationId);
            this.initiator(model.initiator);
            this.participants(model.participants);
            this.resourceMetadata(model.resourceMetadata);
            this.originalParent(model.originalParent);
            this.commentMetadata(model.commentMetadata);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActivityType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final UserMetadata.Builder getInitiator() {
            return this.initiator != null ? this.initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(UserMetadata initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(UserMetadata.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        public final Participants.Builder getParticipants() {
            return this.participants != null ? this.participants.toBuilder() : null;
        }

        @Override
        public final Builder participants(Participants participants) {
            this.participants = participants;
            return this;
        }

        public final void setParticipants(Participants.BuilderImpl participants) {
            this.participants = participants != null ? participants.build() : null;
        }

        public final ResourceMetadata.Builder getResourceMetadata() {
            return this.resourceMetadata != null ? this.resourceMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resourceMetadata(ResourceMetadata resourceMetadata) {
            this.resourceMetadata = resourceMetadata;
            return this;
        }

        public final void setResourceMetadata(ResourceMetadata.BuilderImpl resourceMetadata) {
            this.resourceMetadata = resourceMetadata != null ? resourceMetadata.build() : null;
        }

        public final ResourceMetadata.Builder getOriginalParent() {
            return this.originalParent != null ? this.originalParent.toBuilder() : null;
        }

        @Override
        public final Builder originalParent(ResourceMetadata originalParent) {
            this.originalParent = originalParent;
            return this;
        }

        public final void setOriginalParent(ResourceMetadata.BuilderImpl originalParent) {
            this.originalParent = originalParent != null ? originalParent.build() : null;
        }

        public final CommentMetadata.Builder getCommentMetadata() {
            return this.commentMetadata != null ? this.commentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder commentMetadata(CommentMetadata commentMetadata) {
            this.commentMetadata = commentMetadata;
            return this;
        }

        public final void setCommentMetadata(CommentMetadata.BuilderImpl commentMetadata) {
            this.commentMetadata = commentMetadata != null ? commentMetadata.build() : null;
        }

        public Activity build() {
            return new Activity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Activity> {
        public Builder type(String var1);

        public Builder type(ActivityType var1);

        public Builder timeStamp(Instant var1);

        public Builder organizationId(String var1);

        public Builder initiator(UserMetadata var1);

        public Builder participants(Participants var1);

        public Builder resourceMetadata(ResourceMetadata var1);

        public Builder originalParent(ResourceMetadata var1);

        public Builder commentMetadata(CommentMetadata var1);
    }
}

