/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;

@SdkInternalApi
public class StorageRuleTypeMarshaller {
    private static final MarshallingInfo<Long> STORAGEALLOCATEDINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageAllocatedInBytes").build();
    private static final MarshallingInfo<String> STORAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageType").build();
    private static final StorageRuleTypeMarshaller INSTANCE = new StorageRuleTypeMarshaller();

    public static StorageRuleTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageRuleType storageRuleType, ProtocolMarshaller protocolMarshaller) {
        if (storageRuleType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageRuleType.storageAllocatedInBytes(), STORAGEALLOCATEDINBYTES_BINDING);
            protocolMarshaller.marshall((Object)storageRuleType.storageType(), STORAGETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

