/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteCustomMetadataRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteCustomMetadataRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final String versionId;
    private final List<String> keys;
    private final Boolean deleteAll;

    private DeleteCustomMetadataRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.versionId = builder.versionId;
        this.keys = builder.keys;
        this.deleteAll = builder.deleteAll;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String versionId() {
        return this.versionId;
    }

    public List<String> keys() {
        return this.keys;
    }

    public Boolean deleteAll() {
        return this.deleteAll;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.keys() == null ? 0 : this.keys().hashCode());
        hashCode = 31 * hashCode + (this.deleteAll() == null ? 0 : this.deleteAll().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomMetadataRequest)) {
            return false;
        }
        DeleteCustomMetadataRequest other = (DeleteCustomMetadataRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.keys() == null ^ this.keys() == null) {
            return false;
        }
        if (other.keys() != null && !other.keys().equals(this.keys())) {
            return false;
        }
        if (other.deleteAll() == null ^ this.deleteAll() == null) {
            return false;
        }
        return other.deleteAll() == null || other.deleteAll().equals(this.deleteAll());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.keys() != null) {
            sb.append("Keys: ").append(this.keys()).append(",");
        }
        if (this.deleteAll() != null) {
            sb.append("DeleteAll: ").append(this.deleteAll()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private String versionId;
        private List<String> keys;
        private Boolean deleteAll;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomMetadataRequest model) {
            this.setAuthenticationToken(model.authenticationToken);
            this.setResourceId(model.resourceId);
            this.setVersionId(model.versionId);
            this.setKeys(model.keys);
            this.setDeleteAll(model.deleteAll);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<String> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = CustomMetadataKeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = CustomMetadataKeyListCopier.copy(keys);
        }

        public final Boolean getDeleteAll() {
            return this.deleteAll;
        }

        @Override
        public final Builder deleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
            return this;
        }

        public final void setDeleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
        }

        public DeleteCustomMetadataRequest build() {
            return new DeleteCustomMetadataRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteCustomMetadataRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder versionId(String var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder deleteAll(Boolean var1);
    }
}

