/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.Subscription;

@SdkInternalApi
public class SubscriptionMarshaller {
    private static final MarshallingInfo<String> SUBSCRIPTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionId").build();
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndPoint").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocol").build();
    private static final SubscriptionMarshaller INSTANCE = new SubscriptionMarshaller();

    public static SubscriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subscription subscription, ProtocolMarshaller protocolMarshaller) {
        if (subscription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subscription.subscriptionId(), SUBSCRIPTIONID_BINDING);
            protocolMarshaller.marshall((Object)subscription.endPoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)subscription.protocol(), PROTOCOL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

