/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.transform.CommentMetadataUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.ParticipantsUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.ResourceMetadataUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UserMetadataUnmarshaller;

public class ActivityUnmarshaller
implements Unmarshaller<Activity, JsonUnmarshallerContext> {
    private static final ActivityUnmarshaller INSTANCE = new ActivityUnmarshaller();

    public Activity unmarshall(JsonUnmarshallerContext context) throws Exception {
        Activity.Builder activityBuilder = Activity.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    activityBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TimeStamp", targetDepth)) {
                    context.nextToken();
                    activityBuilder.timeStamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("OrganizationId", targetDepth)) {
                    context.nextToken();
                    activityBuilder.organizationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Initiator", targetDepth)) {
                    context.nextToken();
                    activityBuilder.initiator(UserMetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Participants", targetDepth)) {
                    context.nextToken();
                    activityBuilder.participants(ParticipantsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ResourceMetadata", targetDepth)) {
                    context.nextToken();
                    activityBuilder.resourceMetadata(ResourceMetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("OriginalParent", targetDepth)) {
                    context.nextToken();
                    activityBuilder.originalParent(ResourceMetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CommentMetadata", targetDepth)) {
                    context.nextToken();
                    activityBuilder.commentMetadata(CommentMetadataUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Activity)activityBuilder.build();
    }

    public static ActivityUnmarshaller getInstance() {
        return INSTANCE;
    }
}

