/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.RolePermissionType;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.services.workdocs.transform.PermissionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PermissionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, PermissionInfo> {
    private final String role;
    private final String type;

    private PermissionInfo(BuilderImpl builder) {
        this.role = builder.role;
        this.type = builder.type;
    }

    public String role() {
        return this.role;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.role() == null ? 0 : this.role().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo other = (PermissionInfo)obj;
        if (other.role() == null ^ this.role() == null) {
            return false;
        }
        if (other.role() != null && !other.role().equals(this.role())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.role() != null) {
            sb.append("Role: ").append(this.role()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String role;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionInfo model) {
            this.setRole(model.role);
            this.setType(model.type);
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RolePermissionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public PermissionInfo build() {
            return new PermissionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PermissionInfo> {
        public Builder role(String var1);

        public Builder role(RoleType var1);

        public Builder type(String var1);

        public Builder type(RolePermissionType var1);
    }
}

