/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.LabelsCopier;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.services.workdocs.transform.DocumentMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentMetadata> {
    private final String id;
    private final String creatorId;
    private final String parentFolderId;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final DocumentVersionMetadata latestVersionMetadata;
    private final String resourceState;
    private final List<String> labels;

    private DocumentMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.latestVersionMetadata = builder.latestVersionMetadata;
        this.resourceState = builder.resourceState;
        this.labels = builder.labels;
    }

    public String id() {
        return this.id;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public DocumentVersionMetadata latestVersionMetadata() {
        return this.latestVersionMetadata;
    }

    public String resourceState() {
        return this.resourceState;
    }

    public List<String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.creatorId() == null ? 0 : this.creatorId().hashCode());
        hashCode = 31 * hashCode + (this.parentFolderId() == null ? 0 : this.parentFolderId().hashCode());
        hashCode = 31 * hashCode + (this.createdTimestamp() == null ? 0 : this.createdTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.modifiedTimestamp() == null ? 0 : this.modifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.latestVersionMetadata() == null ? 0 : this.latestVersionMetadata().hashCode());
        hashCode = 31 * hashCode + (this.resourceState() == null ? 0 : this.resourceState().hashCode());
        hashCode = 31 * hashCode + (this.labels() == null ? 0 : this.labels().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.creatorId() == null ^ this.creatorId() == null) {
            return false;
        }
        if (other.creatorId() != null && !other.creatorId().equals(this.creatorId())) {
            return false;
        }
        if (other.parentFolderId() == null ^ this.parentFolderId() == null) {
            return false;
        }
        if (other.parentFolderId() != null && !other.parentFolderId().equals(this.parentFolderId())) {
            return false;
        }
        if (other.createdTimestamp() == null ^ this.createdTimestamp() == null) {
            return false;
        }
        if (other.createdTimestamp() != null && !other.createdTimestamp().equals(this.createdTimestamp())) {
            return false;
        }
        if (other.modifiedTimestamp() == null ^ this.modifiedTimestamp() == null) {
            return false;
        }
        if (other.modifiedTimestamp() != null && !other.modifiedTimestamp().equals(this.modifiedTimestamp())) {
            return false;
        }
        if (other.latestVersionMetadata() == null ^ this.latestVersionMetadata() == null) {
            return false;
        }
        if (other.latestVersionMetadata() != null && !other.latestVersionMetadata().equals(this.latestVersionMetadata())) {
            return false;
        }
        if (other.resourceState() == null ^ this.resourceState() == null) {
            return false;
        }
        if (other.resourceState() != null && !other.resourceState().equals(this.resourceState())) {
            return false;
        }
        if (other.labels() == null ^ this.labels() == null) {
            return false;
        }
        return other.labels() == null || other.labels().equals(this.labels());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        if (this.parentFolderId() != null) {
            sb.append("ParentFolderId: ").append(this.parentFolderId()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.modifiedTimestamp() != null) {
            sb.append("ModifiedTimestamp: ").append(this.modifiedTimestamp()).append(",");
        }
        if (this.latestVersionMetadata() != null) {
            sb.append("LatestVersionMetadata: ").append(this.latestVersionMetadata()).append(",");
        }
        if (this.resourceState() != null) {
            sb.append("ResourceState: ").append(this.resourceState()).append(",");
        }
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String creatorId;
        private String parentFolderId;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private DocumentVersionMetadata latestVersionMetadata;
        private String resourceState;
        private List<String> labels;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            this.setId(model.id);
            this.setCreatorId(model.creatorId);
            this.setParentFolderId(model.parentFolderId);
            this.setCreatedTimestamp(model.createdTimestamp);
            this.setModifiedTimestamp(model.modifiedTimestamp);
            this.setLatestVersionMetadata(model.latestVersionMetadata);
            this.setResourceState(model.resourceState);
            this.setLabels(model.labels);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final DocumentVersionMetadata getLatestVersionMetadata() {
            return this.latestVersionMetadata;
        }

        @Override
        public final Builder latestVersionMetadata(DocumentVersionMetadata latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata;
            return this;
        }

        public final void setLatestVersionMetadata(DocumentVersionMetadata latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata;
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = LabelsCopier.copy(labels);
        }

        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentMetadata> {
        public Builder id(String var1);

        public Builder creatorId(String var1);

        public Builder parentFolderId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder latestVersionMetadata(DocumentVersionMetadata var1);

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);
    }
}

