/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDocumentVersionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDocumentVersionResponse> {
    private final DocumentVersionMetadata metadata;
    private final Map<String, String> customMetadata;

    private GetDocumentVersionResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    public DocumentVersionMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.customMetadata() == null ? 0 : this.customMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentVersionResponse)) {
            return false;
        }
        GetDocumentVersionResponse other = (GetDocumentVersionResponse)((Object)obj);
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.customMetadata() == null ^ this.customMetadata() == null) {
            return false;
        }
        return other.customMetadata() == null || other.customMetadata().equals(this.customMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.customMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.customMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private DocumentVersionMetadata metadata;
        private Map<String, String> customMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentVersionResponse model) {
            this.setMetadata(model.metadata);
            this.setCustomMetadata(model.customMetadata);
        }

        public final DocumentVersionMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(DocumentVersionMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(DocumentVersionMetadata metadata) {
            this.metadata = metadata;
        }

        public final Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        public GetDocumentVersionResponse build() {
            return new GetDocumentVersionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDocumentVersionResponse> {
        public Builder metadata(DocumentVersionMetadata var1);

        public Builder customMetadata(Map<String, String> var1);
    }
}

