/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.Subscription;
import software.amazon.awssdk.services.workdocs.model.SubscriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNotificationSubscriptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNotificationSubscriptionsResponse> {
    private final List<Subscription> subscriptions;
    private final String marker;

    private DescribeNotificationSubscriptionsResponse(BuilderImpl builder) {
        this.subscriptions = builder.subscriptions;
        this.marker = builder.marker;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptions() == null ? 0 : this.subscriptions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationSubscriptionsResponse)) {
            return false;
        }
        DescribeNotificationSubscriptionsResponse other = (DescribeNotificationSubscriptionsResponse)((Object)obj);
        if (other.subscriptions() == null ^ this.subscriptions() == null) {
            return false;
        }
        if (other.subscriptions() != null && !other.subscriptions().equals(this.subscriptions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptions() != null) {
            sb.append("Subscriptions: ").append(this.subscriptions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationSubscriptionsResponse model) {
            this.setSubscriptions(model.subscriptions);
            this.setMarker(model.marker);
        }

        public final Collection<Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
        }

        @SafeVarargs
        public final void setSubscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeNotificationSubscriptionsResponse build() {
            return new DescribeNotificationSubscriptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNotificationSubscriptionsResponse> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder marker(String var1);
    }
}

