/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.workdocs.model.PrincipalType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveResourcePermissionRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, RemoveResourcePermissionRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final String principalId;
    private final String principalType;

    private RemoveResourcePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String principalId() {
        return this.principalId;
    }

    public PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public String principalTypeAsString() {
        return this.principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveResourcePermissionRequest)) {
            return false;
        }
        RemoveResourcePermissionRequest other = (RemoveResourcePermissionRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"RemoveResourcePermissionRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("ResourceId", (Object)this.resourceId()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private String principalId;
        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveResourcePermissionRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.resourceId(model.resourceId);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType.toString());
            return this;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveResourcePermissionRequest build() {
            return new RemoveResourcePermissionRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, RemoveResourcePermissionRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

