/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.ActivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.ActivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.ConcurrentModificationException;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCommentResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.CreateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.CreateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.services.workdocs.model.CreateUserResponse;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeactivatingLastSystemUserException;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteUserResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentLockedForCommentsException;
import software.amazon.awssdk.services.workdocs.model.DraftUploadOutOfSyncException;
import software.amazon.awssdk.services.workdocs.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.workdocs.model.EntityNotExistsException;
import software.amazon.awssdk.services.workdocs.model.FailedDependencyException;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderResponse;
import software.amazon.awssdk.services.workdocs.model.IllegalUserStateException;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.InvalidArgumentException;
import software.amazon.awssdk.services.workdocs.model.InvalidOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidPasswordException;
import software.amazon.awssdk.services.workdocs.model.LimitExceededException;
import software.amazon.awssdk.services.workdocs.model.ProhibitedStateException;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionResponse;
import software.amazon.awssdk.services.workdocs.model.ResourceAlreadyCheckedOutException;
import software.amazon.awssdk.services.workdocs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitWillExceedException;
import software.amazon.awssdk.services.workdocs.model.TooManyLabelsException;
import software.amazon.awssdk.services.workdocs.model.TooManySubscriptionsException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedResourceAccessException;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateUserResponse;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.services.workdocs.paginators.DescribeDocumentVersionsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeFolderContentsPublisher;
import software.amazon.awssdk.services.workdocs.paginators.DescribeUsersPublisher;
import software.amazon.awssdk.services.workdocs.transform.AbortDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.AbortDocumentVersionUploadResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.ActivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.ActivateUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.AddResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.AddResourcePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCommentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCustomMetadataResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateNotificationSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeactivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeactivateUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCommentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCustomMetadataResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderContentsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteNotificationSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeActivitiesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeActivitiesResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeCommentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeCommentsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeDocumentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeFolderContentsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeGroupsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeNotificationSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeNotificationSubscriptionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeResourcePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeRootFoldersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeRootFoldersResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeUsersResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetCurrentUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetCurrentUserResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentPathResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderPathResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.InitiateDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.InitiateDocumentVersionUploadResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveAllResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveAllResourcePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveResourcePermissionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveResourcePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateFolderResponseUnmarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateUserResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultWorkDocsAsyncClient
implements WorkDocsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkDocsAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultWorkDocsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "workdocs";
    }

    @Override
    public CompletableFuture<AbortDocumentVersionUploadResponse> abortDocumentVersionUpload(AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AbortDocumentVersionUploadResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AbortDocumentVersionUploadRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortDocumentVersionUploadRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ActivateUserResponse> activateUser(ActivateUserRequest activateUserRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivateUserResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ActivateUserRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)activateUserRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddResourcePermissionsResponse> addResourcePermissions(AddResourcePermissionsRequest addResourcePermissionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddResourcePermissionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AddResourcePermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addResourcePermissionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCommentResponse> createComment(CreateCommentRequest createCommentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCommentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateCommentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCommentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomMetadataResponse> createCustomMetadata(CreateCustomMetadataRequest createCustomMetadataRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCustomMetadataResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateCustomMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomMetadataRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFolderResponse> createFolder(CreateFolderRequest createFolderRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFolderResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateFolderRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFolderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLabelsResponse> createLabels(CreateLabelsRequest createLabelsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLabelsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateLabelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLabelsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateNotificationSubscriptionResponse> createNotificationSubscription(CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNotificationSubscriptionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateNotificationSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNotificationSubscriptionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateUserResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateUserRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeactivateUserResponse> deactivateUser(DeactivateUserRequest deactivateUserRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivateUserResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeactivateUserRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deactivateUserRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCommentResponse> deleteComment(DeleteCommentRequest deleteCommentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCommentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteCommentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCommentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomMetadataResponse> deleteCustomMetadata(DeleteCustomMetadataRequest deleteCustomMetadataRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCustomMetadataResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteCustomMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomMetadataRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDocumentResponse> deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDocumentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDocumentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDocumentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFolderResponse> deleteFolder(DeleteFolderRequest deleteFolderRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFolderResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteFolderRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFolderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFolderContentsResponse> deleteFolderContents(DeleteFolderContentsRequest deleteFolderContentsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFolderContentsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteFolderContentsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFolderContentsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLabelsResponse> deleteLabels(DeleteLabelsRequest deleteLabelsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLabelsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLabelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLabelsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNotificationSubscriptionResponse> deleteNotificationSubscription(DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNotificationSubscriptionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteNotificationSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNotificationSubscriptionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteUserRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeActivitiesResponse> describeActivities(DescribeActivitiesRequest describeActivitiesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeActivitiesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeActivitiesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeActivitiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCommentsResponse> describeComments(DescribeCommentsRequest describeCommentsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCommentsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeCommentsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCommentsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDocumentVersionsResponse> describeDocumentVersions(DescribeDocumentVersionsRequest describeDocumentVersionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDocumentVersionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeDocumentVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDocumentVersionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDocumentVersionsPublisher describeDocumentVersionsPaginator(DescribeDocumentVersionsRequest describeDocumentVersionsRequest) {
        return new DescribeDocumentVersionsPublisher(this, this.applyPaginatorUserAgent(describeDocumentVersionsRequest));
    }

    @Override
    public CompletableFuture<DescribeFolderContentsResponse> describeFolderContents(DescribeFolderContentsRequest describeFolderContentsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFolderContentsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeFolderContentsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFolderContentsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeFolderContentsPublisher describeFolderContentsPaginator(DescribeFolderContentsRequest describeFolderContentsRequest) {
        return new DescribeFolderContentsPublisher(this, this.applyPaginatorUserAgent(describeFolderContentsRequest));
    }

    @Override
    public CompletableFuture<DescribeGroupsResponse> describeGroups(DescribeGroupsRequest describeGroupsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeGroupsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNotificationSubscriptionsResponse> describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNotificationSubscriptionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeNotificationSubscriptionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNotificationSubscriptionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourcePermissionsResponse> describeResourcePermissions(DescribeResourcePermissionsRequest describeResourcePermissionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeResourcePermissionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeResourcePermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourcePermissionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRootFoldersResponse> describeRootFolders(DescribeRootFoldersRequest describeRootFoldersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRootFoldersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeRootFoldersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRootFoldersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUsersResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeUsersRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUsersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeUsersPublisher describeUsersPaginator(DescribeUsersRequest describeUsersRequest) {
        return new DescribeUsersPublisher(this, this.applyPaginatorUserAgent(describeUsersRequest));
    }

    @Override
    public CompletableFuture<GetCurrentUserResponse> getCurrentUser(GetCurrentUserRequest getCurrentUserRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCurrentUserResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCurrentUserRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCurrentUserRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDocumentResponse> getDocument(GetDocumentRequest getDocumentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDocumentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDocumentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDocumentPathResponse> getDocumentPath(GetDocumentPathRequest getDocumentPathRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentPathResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDocumentPathRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDocumentPathRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDocumentVersionResponse> getDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentVersionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDocumentVersionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDocumentVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFolderResponse> getFolder(GetFolderRequest getFolderRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFolderResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetFolderRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFolderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFolderPathResponse> getFolderPath(GetFolderPathRequest getFolderPathRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFolderPathResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetFolderPathRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFolderPathRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitiateDocumentVersionUploadResponse> initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateDocumentVersionUploadResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new InitiateDocumentVersionUploadRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateDocumentVersionUploadRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveAllResourcePermissionsResponse> removeAllResourcePermissions(RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveAllResourcePermissionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RemoveAllResourcePermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeAllResourcePermissionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveResourcePermissionResponse> removeResourcePermission(RemoveResourcePermissionRequest removeResourcePermissionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveResourcePermissionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RemoveResourcePermissionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeResourcePermissionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDocumentResponse> updateDocument(UpdateDocumentRequest updateDocumentRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDocumentResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateDocumentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDocumentRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDocumentVersionResponse> updateDocumentVersion(UpdateDocumentVersionRequest updateDocumentVersionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDocumentVersionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateDocumentVersionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDocumentVersionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFolderResponse> updateFolder(UpdateFolderRequest updateFolderRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFolderResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateFolderRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFolderRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateUserRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(WorkDocsException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FailedDependencyException").withModeledClass(FailedDependencyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(InvalidOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CustomMetadataLimitExceededException").withModeledClass(CustomMetadataLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedResourceAccessException").withModeledClass(UnauthorizedResourceAccessException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManySubscriptionsException").withModeledClass(TooManySubscriptionsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityAlreadyExistsException").withModeledClass(EntityAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityNotExistsException").withModeledClass(EntityNotExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DocumentLockedForCommentsException").withModeledClass(DocumentLockedForCommentsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StorageLimitExceededException").withModeledClass(StorageLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StorageLimitWillExceedException").withModeledClass(StorageLimitWillExceedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProhibitedStateException").withModeledClass(ProhibitedStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IllegalUserStateException").withModeledClass(IllegalUserStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPasswordException").withModeledClass(InvalidPasswordException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperationException").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyLabelsException").withModeledClass(TooManyLabelsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DraftUploadOutOfSyncException").withModeledClass(DraftUploadOutOfSyncException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyCheckedOutException").withModeledClass(ResourceAlreadyCheckedOutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DeactivatingLastSystemUserException").withModeledClass(DeactivatingLastSystemUserException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    private <T extends WorkDocsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WorkDocsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

