/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActivityMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeStamp").isBinary(false).build();
    private static final MarshallingInfo<String> ORGANIZATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INITIATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Initiator").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARTICIPANTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Participants").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceMetadata").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ORIGINALPARENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OriginalParent").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMMENTMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommentMetadata").isBinary(false).build();
    private static final ActivityMarshaller INSTANCE = new ActivityMarshaller();

    private ActivityMarshaller() {
    }

    public static ActivityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Activity activity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)activity, (String)"activity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)activity.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)activity.timeStamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)activity.organizationId(), ORGANIZATIONID_BINDING);
            protocolMarshaller.marshall((Object)activity.initiator(), INITIATOR_BINDING);
            protocolMarshaller.marshall((Object)activity.participants(), PARTICIPANTS_BINDING);
            protocolMarshaller.marshall((Object)activity.resourceMetadata(), RESOURCEMETADATA_BINDING);
            protocolMarshaller.marshall((Object)activity.originalParent(), ORIGINALPARENT_BINDING);
            protocolMarshaller.marshall((Object)activity.commentMetadata(), COMMENTMETADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

