/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;
import software.amazon.awssdk.services.workdocs.transform.UserStorageMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserStorageMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, UserStorageMetadata> {
    private final Long storageUtilizedInBytes;
    private final StorageRuleType storageRule;

    private UserStorageMetadata(BuilderImpl builder) {
        this.storageUtilizedInBytes = builder.storageUtilizedInBytes;
        this.storageRule = builder.storageRule;
    }

    public Long storageUtilizedInBytes() {
        return this.storageUtilizedInBytes;
    }

    public StorageRuleType storageRule() {
        return this.storageRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageUtilizedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageRule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStorageMetadata)) {
            return false;
        }
        UserStorageMetadata other = (UserStorageMetadata)obj;
        return Objects.equals(this.storageUtilizedInBytes(), other.storageUtilizedInBytes()) && Objects.equals(this.storageRule(), other.storageRule());
    }

    public String toString() {
        return ToString.builder((String)"UserStorageMetadata").add("StorageUtilizedInBytes", (Object)this.storageUtilizedInBytes()).add("StorageRule", (Object)this.storageRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageUtilizedInBytes": {
                return Optional.ofNullable(clazz.cast(this.storageUtilizedInBytes()));
            }
            case "StorageRule": {
                return Optional.ofNullable(clazz.cast(this.storageRule()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserStorageMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long storageUtilizedInBytes;
        private StorageRuleType storageRule;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStorageMetadata model) {
            this.storageUtilizedInBytes(model.storageUtilizedInBytes);
            this.storageRule(model.storageRule);
        }

        public final Long getStorageUtilizedInBytes() {
            return this.storageUtilizedInBytes;
        }

        @Override
        public final Builder storageUtilizedInBytes(Long storageUtilizedInBytes) {
            this.storageUtilizedInBytes = storageUtilizedInBytes;
            return this;
        }

        public final void setStorageUtilizedInBytes(Long storageUtilizedInBytes) {
            this.storageUtilizedInBytes = storageUtilizedInBytes;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return this.storageRule != null ? this.storageRule.toBuilder() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        public UserStorageMetadata build() {
            return new UserStorageMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserStorageMetadata> {
        public Builder storageUtilizedInBytes(Long var1);

        public Builder storageRule(StorageRuleType var1);

        default public Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return this.storageRule((StorageRuleType)((StorageRuleType.Builder)StorageRuleType.builder().applyMutation(storageRule)).build());
        }
    }
}

