/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.NotificationOptions;
import software.amazon.awssdk.services.workdocs.model.SharePrincipal;
import software.amazon.awssdk.services.workdocs.model.SharePrincipalListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddResourcePermissionsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, AddResourcePermissionsRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final List<SharePrincipal> principals;
    private final NotificationOptions notificationOptions;

    private AddResourcePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.principals = builder.principals;
        this.notificationOptions = builder.notificationOptions;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<SharePrincipal> principals() {
        return this.principals;
    }

    public NotificationOptions notificationOptions() {
        return this.notificationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddResourcePermissionsRequest)) {
            return false;
        }
        AddResourcePermissionsRequest other = (AddResourcePermissionsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.notificationOptions(), other.notificationOptions());
    }

    public String toString() {
        return ToString.builder((String)"AddResourcePermissionsRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("ResourceId", (Object)this.resourceId()).add("Principals", this.principals()).add("NotificationOptions", (Object)this.notificationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "NotificationOptions": {
                return Optional.ofNullable(clazz.cast(this.notificationOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private List<SharePrincipal> principals = DefaultSdkAutoConstructList.getInstance();
        private NotificationOptions notificationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AddResourcePermissionsRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.resourceId(model.resourceId);
            this.principals(model.principals);
            this.notificationOptions(model.notificationOptions);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<SharePrincipal.Builder> getPrincipals() {
            return this.principals != null ? (Collection)this.principals.stream().map(SharePrincipal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principals(Collection<SharePrincipal> principals) {
            this.principals = SharePrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(SharePrincipal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<SharePrincipal.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (SharePrincipal)((SharePrincipal.Builder)SharePrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<SharePrincipal.BuilderImpl> principals) {
            this.principals = SharePrincipalListCopier.copyFromBuilder(principals);
        }

        public final NotificationOptions.Builder getNotificationOptions() {
            return this.notificationOptions != null ? this.notificationOptions.toBuilder() : null;
        }

        @Override
        public final Builder notificationOptions(NotificationOptions notificationOptions) {
            this.notificationOptions = notificationOptions;
            return this;
        }

        public final void setNotificationOptions(NotificationOptions.BuilderImpl notificationOptions) {
            this.notificationOptions = notificationOptions != null ? notificationOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddResourcePermissionsRequest build() {
            return new AddResourcePermissionsRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, AddResourcePermissionsRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder principals(Collection<SharePrincipal> var1);

        public Builder principals(SharePrincipal ... var1);

        public Builder principals(Consumer<SharePrincipal.Builder> ... var1);

        public Builder notificationOptions(NotificationOptions var1);

        default public Builder notificationOptions(Consumer<NotificationOptions.Builder> notificationOptions) {
            return this.notificationOptions((NotificationOptions)((NotificationOptions.Builder)NotificationOptions.builder().applyMutation(notificationOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

