/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.UserStorageMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserStorageMetadataMarshaller {
    private static final MarshallingInfo<Long> STORAGEUTILIZEDINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageUtilizedInBytes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STORAGERULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageRule").isBinary(false).build();
    private static final UserStorageMetadataMarshaller INSTANCE = new UserStorageMetadataMarshaller();

    private UserStorageMetadataMarshaller() {
    }

    public static UserStorageMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserStorageMetadata userStorageMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userStorageMetadata, (String)"userStorageMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userStorageMetadata.storageUtilizedInBytes(), STORAGEUTILIZEDINBYTES_BINDING);
            protocolMarshaller.marshall((Object)userStorageMetadata.storageRule(), STORAGERULE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

