/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserMetadataMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> GIVENNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GivenName").isBinary(false).build();
    private static final MarshallingInfo<String> SURNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Surname").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").isBinary(false).build();
    private static final UserMetadataMarshaller INSTANCE = new UserMetadataMarshaller();

    private UserMetadataMarshaller() {
    }

    public static UserMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserMetadata userMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userMetadata, (String)"userMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)userMetadata.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)userMetadata.givenName(), GIVENNAME_BINDING);
            protocolMarshaller.marshall((Object)userMetadata.surname(), SURNAME_BINDING);
            protocolMarshaller.marshall((Object)userMetadata.emailAddress(), EMAILADDRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

