/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.ShareResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ShareResultMarshaller {
    private static final MarshallingInfo<String> PRINCIPALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrincipalId").isBinary(false).build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> SHAREID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShareId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final ShareResultMarshaller INSTANCE = new ShareResultMarshaller();

    private ShareResultMarshaller() {
    }

    public static ShareResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ShareResult shareResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)shareResult, (String)"shareResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)shareResult.principalId(), PRINCIPALID_BINDING);
            protocolMarshaller.marshall((Object)shareResult.roleAsString(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)shareResult.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)shareResult.shareId(), SHAREID_BINDING);
            protocolMarshaller.marshall((Object)shareResult.statusMessage(), STATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

