/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteUserRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("UserId").isBinary(false).build();
    private static final DeleteUserRequestModelMarshaller INSTANCE = new DeleteUserRequestModelMarshaller();

    private DeleteUserRequestModelMarshaller() {
    }

    public static DeleteUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteUserRequest deleteUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteUserRequest), (String)"deleteUserRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteUserRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)deleteUserRequest.userId(), USERID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

