/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLabelsRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Labels").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final CreateLabelsRequestModelMarshaller INSTANCE = new CreateLabelsRequestModelMarshaller();

    private CreateLabelsRequestModelMarshaller() {
    }

    public static CreateLabelsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateLabelsRequest createLabelsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createLabelsRequest), (String)"createLabelsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createLabelsRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(createLabelsRequest.labels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)createLabelsRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

