/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;

public class DescribeFolderContentsIterable
implements SdkIterable<DescribeFolderContentsResponse> {
    private final WorkDocsClient client;
    private final DescribeFolderContentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFolderContentsIterable(WorkDocsClient client, DescribeFolderContentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFolderContentsResponseFetcher();
    }

    public Iterator<DescribeFolderContentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<FolderMetadata> folders() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.folders() != null) {
                return response.folders().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<DocumentMetadata> documents() {
        Function<DescribeFolderContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documents() != null) {
                return response.documents().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeFolderContentsIterable resume(DescribeFolderContentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeFolderContentsIterable(this.client, (DescribeFolderContentsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeFolderContentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeFolderContentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeFolderContentsResponseFetcher
    implements SyncPageFetcher<DescribeFolderContentsResponse> {
        private DescribeFolderContentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFolderContentsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeFolderContentsResponse nextPage(DescribeFolderContentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFolderContentsIterable.this.client.describeFolderContents(DescribeFolderContentsIterable.this.firstRequest);
            }
            return DescribeFolderContentsIterable.this.client.describeFolderContents((DescribeFolderContentsRequest)((Object)DescribeFolderContentsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

