/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.transform.NotificationOptionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, NotificationOptions> {
    private final Boolean sendEmail;
    private final String emailMessage;

    private NotificationOptions(BuilderImpl builder) {
        this.sendEmail = builder.sendEmail;
        this.emailMessage = builder.emailMessage;
    }

    public Boolean sendEmail() {
        return this.sendEmail;
    }

    public String emailMessage() {
        return this.emailMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sendEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions other = (NotificationOptions)obj;
        return Objects.equals(this.sendEmail(), other.sendEmail()) && Objects.equals(this.emailMessage(), other.emailMessage());
    }

    public String toString() {
        return ToString.builder((String)"NotificationOptions").add("SendEmail", (Object)this.sendEmail()).add("EmailMessage", (Object)this.emailMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendEmail": {
                return Optional.of(clazz.cast(this.sendEmail()));
            }
            case "EmailMessage": {
                return Optional.of(clazz.cast(this.emailMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean sendEmail;
        private String emailMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationOptions model) {
            this.sendEmail(model.sendEmail);
            this.emailMessage(model.emailMessage);
        }

        public final Boolean getSendEmail() {
            return this.sendEmail;
        }

        @Override
        public final Builder sendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
            return this;
        }

        public final void setSendEmail(Boolean sendEmail) {
            this.sendEmail = sendEmail;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        public NotificationOptions build() {
            return new NotificationOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationOptions> {
        public Builder sendEmail(Boolean var1);

        public Builder emailMessage(String var1);
    }
}

