/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.OrganizationUserListCopier;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUsersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeUsersResponse> {
    private final List<User> users;
    private final Long totalNumberOfUsers;
    private final String marker;

    private DescribeUsersResponse(BuilderImpl builder) {
        this.users = builder.users;
        this.totalNumberOfUsers = builder.totalNumberOfUsers;
        this.marker = builder.marker;
    }

    public List<User> users() {
        return this.users;
    }

    public Long totalNumberOfUsers() {
        return this.totalNumberOfUsers;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.users() == null ? 0 : this.users().hashCode());
        hashCode = 31 * hashCode + (this.totalNumberOfUsers() == null ? 0 : this.totalNumberOfUsers().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsersResponse)) {
            return false;
        }
        DescribeUsersResponse other = (DescribeUsersResponse)((Object)obj);
        if (other.users() == null ^ this.users() == null) {
            return false;
        }
        if (other.users() != null && !other.users().equals(this.users())) {
            return false;
        }
        if (other.totalNumberOfUsers() == null ^ this.totalNumberOfUsers() == null) {
            return false;
        }
        if (other.totalNumberOfUsers() != null && !other.totalNumberOfUsers().equals(this.totalNumberOfUsers())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.users() != null) {
            sb.append("Users: ").append(this.users()).append(",");
        }
        if (this.totalNumberOfUsers() != null) {
            sb.append("TotalNumberOfUsers: ").append(this.totalNumberOfUsers()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<User> users;
        private Long totalNumberOfUsers;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsersResponse model) {
            this.setUsers(model.users);
            this.setTotalNumberOfUsers(model.totalNumberOfUsers);
            this.setMarker(model.marker);
        }

        public final Collection<User> getUsers() {
            return this.users;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = OrganizationUserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            if (this.users == null) {
                this.users = new ArrayList<User>(users.length);
            }
            for (User e : users) {
                this.users.add(e);
            }
            return this;
        }

        public final void setUsers(Collection<User> users) {
            this.users = OrganizationUserListCopier.copy(users);
        }

        @SafeVarargs
        public final void setUsers(User ... users) {
            if (this.users == null) {
                this.users = new ArrayList<User>(users.length);
            }
            for (User e : users) {
                this.users.add(e);
            }
        }

        public final Long getTotalNumberOfUsers() {
            return this.totalNumberOfUsers;
        }

        @Override
        public final Builder totalNumberOfUsers(Long totalNumberOfUsers) {
            this.totalNumberOfUsers = totalNumberOfUsers;
            return this;
        }

        public final void setTotalNumberOfUsers(Long totalNumberOfUsers) {
            this.totalNumberOfUsers = totalNumberOfUsers;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeUsersResponse build() {
            return new DescribeUsersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeUsersResponse> {
        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder totalNumberOfUsers(Long var1);

        public Builder marker(String var1);
    }
}

