/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContentUploadRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, StartContentUploadRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(StartContentUploadRequest.getter(StartContentUploadRequest::contentType)).setter(StartContentUploadRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(StartContentUploadRequest.getter(StartContentUploadRequest::knowledgeBaseId)).setter(StartContentUploadRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Integer> PRESIGNED_URL_TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("presignedUrlTimeToLive").getter(StartContentUploadRequest.getter(StartContentUploadRequest::presignedUrlTimeToLive)).setter(StartContentUploadRequest.setter(Builder::presignedUrlTimeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlTimeToLive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, KNOWLEDGE_BASE_ID_FIELD, PRESIGNED_URL_TIME_TO_LIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("contentType", CONTENT_TYPE_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("presignedUrlTimeToLive", PRESIGNED_URL_TIME_TO_LIVE_FIELD);
        }
    });
    private final String contentType;
    private final String knowledgeBaseId;
    private final Integer presignedUrlTimeToLive;

    private StartContentUploadRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.presignedUrlTimeToLive = builder.presignedUrlTimeToLive;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final Integer presignedUrlTimeToLive() {
        return this.presignedUrlTimeToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrlTimeToLive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContentUploadRequest)) {
            return false;
        }
        StartContentUploadRequest other = (StartContentUploadRequest)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.presignedUrlTimeToLive(), other.presignedUrlTimeToLive());
    }

    public final String toString() {
        return ToString.builder((String)"StartContentUploadRequest").add("ContentType", (Object)this.contentType()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("PresignedUrlTimeToLive", (Object)this.presignedUrlTimeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "presignedUrlTimeToLive": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlTimeToLive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartContentUploadRequest, T> g) {
        return obj -> g.apply((StartContentUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private String knowledgeBaseId;
        private Integer presignedUrlTimeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContentUploadRequest model) {
            super(model);
            this.contentType(model.contentType);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.presignedUrlTimeToLive(model.presignedUrlTimeToLive);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Integer getPresignedUrlTimeToLive() {
            return this.presignedUrlTimeToLive;
        }

        public final void setPresignedUrlTimeToLive(Integer presignedUrlTimeToLive) {
            this.presignedUrlTimeToLive = presignedUrlTimeToLive;
        }

        @Override
        public final Builder presignedUrlTimeToLive(Integer presignedUrlTimeToLive) {
            this.presignedUrlTimeToLive = presignedUrlTimeToLive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContentUploadRequest build() {
            return new StartContentUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartContentUploadRequest> {
        public Builder contentType(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder presignedUrlTimeToLive(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

